;;; 1998 Copyright OMURA Shinichi, all rights reserved
;;; test data for Object Classifier


;;; test data ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass document ()
  ((title    :initarg :title    :reader doc-title)
   (lang     :initarg :lang     :reader doc-lang)
   (author   :initarg :author   :reader doc-author)
   (category :initarg :category :reader doc-category)
   (keyword  :initarg :keyword  :reader doc-keyword :initform nil)
   (pub-year :initarg :pub-year :reader doc-pub-year :initform 1997)
   )
  )

(defmethod display ((doc document))
  (format t "{~A by ~A#~A#~A#~S}"
    (and (slot-boundp doc 'title) (doc-title doc))
    (and (slot-boundp doc 'author) (doc-author doc))
    (and (slot-boundp doc 'category) (doc-category doc))
    (and (slot-boundp doc 'lang) (doc-lang doc))
    (and (slot-boundp doc 'keyword) (doc-keyword doc))
    (and (slot-boundp doc 'pub-year) (doc-pub-year doc))
    )
  )

(setf doc (list
            (make-instance 'document
                           :title "reference manual"
                           :lang  'japan
                           :author "omura"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "user's manual"
                           :lang  'japan
                           :author "omura"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "Quick Start"
                           :lang  'japan
                           :author "omura"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "reference manual"
                           :lang  'english
                           :author "kokoa"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "user's manual"
                           :lang  'english
                           :author "regro"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "Quick Start"
                           :lang  'english
                           :author "nama"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )

            (make-instance 'document
                           :title "reference manual"
                           :lang  'french
                           :author "nama"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "user's manual"
                           :lang  'french
                           :author "pogre"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "Quick Start"
                           :lang  'french
                           :author "pogre"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            )
      )



(setf  novel (list
              (make-instance 'document
                             :title "one"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babylon" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "two"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babylon" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "three"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babylon" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "light"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babel" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "cure"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babel" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "pure"
                             :lang  'japan
                             :author "shin"
                             :category "Fiction"
                             :keyword '("babel" "sf" "crazy")
                             )
              )

       )


;;; classifier definition ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclassifier
  cf1
  nil
   (lang ()
         (lambda (x y) (doc-lang x) )
         (lambda (x y) (slot-exists-boundp x 'lang)))
   (category (lang)
             (lambda (x y) (doc-category x))
             (lambda (x y) (slot-exists-boundp x 'category)))
   (sf ()
       (lambda (x y) "SF")
       (lambda (x y)
           (and
            (slot-exists-boundp x 'keyword)
            (member "sf" (doc-keyword x)
                    :test #'string-equal))))
   (omura ()
          (lambda (x y) "OMURA")
          (lambda (x y)
              (and
               (slot-exists-boundp x 'author)
               (string-equal "omura" (doc-author x) ))))
   (sf-omura (sf omura)
             (lambda (x y) "OMURA's SF")
             (lambda (x y) t))
   )


(defclassifier
    cf2
  nil
   (lang (t)
         (lambda (x y) (doc-lang x) )
         (lambda (x y) (slot-exists-boundp x 'lang)))
   (category (lang)
             (lambda (x y) (doc-category x))
             (lambda (x y) (slot-exists-boundp x 'category)))
   (keyword (category)
       (lambda (x y) (slot-value x 'keyword))
       (lambda (x y) (slot-exists-boundp x 'keyword) ))
   (author (keyword)
          (lambda (x y) (slot-value x 'author))
          (lambda (x y) (slot-exists-boundp x 'author) ))
   )
#|
(setf tree1 (make-classifier 'cf1))


(put-object* tree1 doc)

(put-object* tree1 novel)

(setf tree2 (make-classifier 'cf2))

(setf re21 (put-object* tree2 doc))
(setf re22 (put-object* tree2 novel))

(pprint (get-all-object* tree1))
(pprint (get-object* tree1))
(setf root1 (get-t-partition tree1))


(show tree1 'display)
(show tree2 'display)

|#