;;; 1998 Copyright OMURA Shinichi, all rights reserved
;;; test data for Object Classifier


(require 'object-browser (merge-pathnames "objbrow.lsp" (current-directory)))

;;; test data ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass document ()
  ((title    :initarg :title    :reader doc-title)
   (lang     :initarg :lang     :reader doc-lang)
   (author   :initarg :author   :reader doc-author)
   (category :initarg :category :reader doc-category)
   (keyword  :initarg :keyword  :reader doc-keyword :initform nil)
   (pub-year :initarg :pub-year :reader doc-pub-year :initform 1997)
   )
  )

(defmethod doc-display ((doc document))
  (format nil "{~A by ~A#~A#~A#~S}"
    (and (slot-boundp doc 'title) (doc-title doc))
    (and (slot-boundp doc 'author) (doc-author doc))
    (and (slot-boundp doc 'category) (doc-category doc))
    (and (slot-boundp doc 'lang) (doc-lang doc))
    (and (slot-boundp doc 'keyword) (doc-keyword doc))
    (and (slot-boundp doc 'pub-year) (doc-pub-year doc))
    )
  )
(defmethod display ((doc document))
  (format nil "{~A by ~A#~A#~A#~S}"
    (and (slot-boundp doc 'title) (doc-title doc))
    (and (slot-boundp doc 'author) (doc-author doc))
    (and (slot-boundp doc 'category) (doc-category doc))
    (and (slot-boundp doc 'lang) (doc-lang doc))
    (and (slot-boundp doc 'keyword) (doc-keyword doc))
    (and (slot-boundp doc 'pub-year) (doc-pub-year doc))
    )
  )

(setf doc (list
            (make-instance 'document
                           :title "reference manual"
                           :lang  'japan
                           :author "omura"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "user's manual"
                           :lang  'japan
                           :author "omura"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "Quick Start"
                           :lang  'japan
                           :author "omura"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "reference manual"
                           :lang  'english
                           :author "kokoa"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "user's manual"
                           :lang  'english
                           :author "regro"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "Quick Start"
                           :lang  'english
                           :author "nama"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )

            (make-instance 'document
                           :title "reference manual"
                           :lang  'french
                           :author "nama"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "user's manual"
                           :lang  'french
                           :author "pogre"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "Quick Start"
                           :lang  'french
                           :author "pogre"
                           :category "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            )
      )



(setf  novel (list
              (make-instance 'document
                             :title "one"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babylon" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "two"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babylon" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "three"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babylon" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "light"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babel" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "cure"
                             :lang  'japan
                             :author "shin"
                             :category "Novel"
                             :keyword '("babel" "sf" "crazy")
                             )
              (make-instance 'document
                             :title "pure"
                             :lang  'japan
                             :author "shin"
                             :category "Fiction"
                             :keyword '("babel" "sf" "crazy")
                             )
              )

       )


;;; classifier definition ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; //̏ŕނ

(defclassifier
    cf1
    nil
  (author ()
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  (lang (author)
   (lambda (x y) (doc-lang x) )
   (lambda (x y) (slot-exists-boundp x 'lang)))
  (category (lang)
    (lambda (x y) (doc-category x))
    (lambda (x y) (slot-exists-boundp x 'category)))
  )


;(setf w1 (ObjectBrowser 'cf1 doc 'doc-display))
;(put-obj* w1 novel )
(ObjectBrowser 'cf1 doc)
(ObjectBrowser 'cf1 (append doc novel) 'doc-display)

;;; 1Ƃ͋tɁA//҂̏ŕނ

(defclassifier
    cf2
    nil
  (category ()
    (lambda (x y) (doc-category x))
    (lambda (x y) (slot-exists-boundp x 'category)))
  (author (category)
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  (lang (author)
   (lambda (x y) (doc-lang x) )
   (lambda (x y) (slot-exists-boundp x 'lang)))
  )

;(ObjectBrowser 'cf2 doc 'doc-display)
(ObjectBrowser 'cf2 doc)

;;; 1  2 ЂƂclassifierɍ̂B
:;; t ̒ɓ̓Ɨޖ؂ł

(defclassifier
    cf3
    nil
  (author1 ()
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  (lang1 (author1)
   (lambda (x y) (doc-lang x) )
   (lambda (x y) (slot-exists-boundp x 'lang)))
  (category1 (lang1)
    (lambda (x y) (doc-category x))
    (lambda (x y) (slot-exists-boundp x 'category)))
  (category2 ()
    (lambda (x y) (doc-category x))
    (lambda (x y) (slot-exists-boundp x 'category)))
  (author2 (category2)
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  (lang2 (author2)
   (lambda (x y) (doc-lang x) )
   (lambda (x y) (slot-exists-boundp x 'lang)))
  )

;(ObjectBrowser 'cf3 doc 'doc-display)
(ObjectBrowser 'cf3 doc)

;;; ֐Ƃ͂ȋ

(defun categoy-of (x y) (doc-category x))
(defun category-exists? (x y)(slot-exists-boundp x 'category))
(defun auther-of (x y) (doc-author x))
(defun author-exists? (x y) (slot-exists-boundp x 'author))
(defun lang-of (x y) (doc-lang x))
(defun lang-exists? (x y) (slot-exists-boundp x 'lang))

(defclassifier
    cf4
    nil
  (category ()
    categoy-of
    category-exists?)
  (author (category)
    auther-of
    author-exists?)
  (lang ()
   lang-of
   lang-exists?)
  )

(ObjectBrowser 'cf4 doc)

;(ObjectBrowser 'cf4 doc 'doc-display)
