;;; 1998 Copyright OMURA Shinichi, all rights reserved
;;; file browser -- sample

;(in-package "object-browser-package" :use "COMMON-LISP-USER")

(require 'object-browser (merge-pathnames "objbrow.lsp" (current-directory)))

#|
;; interface

(filebrowser classifier directory)

1. I collect all files in directory. make file agent for them.
2. classify them.
3. browser it

reference::

(pprint
(directory (directory-namestring (merge-pathnames "*\\" ".")))
)
(current-directory))))
|#


(defun filebrowser (cl directory &optional display)
   (let (obj*)
      (setf obj* (make-fs-object directory))
      (ObjectBrowser cl obj* display)
      )
   )

#|
;; get files from directory

(defclass attribute-object ()
    (
      (read-only  :initarg :read-only  :reader read-only)
      (hidden     :initarg :hidden     :reader hidden)
      (system     :initarg :system     :reader system)
      (directory  :initarg :directory  :reader directory)
      (archive    :initarg :archive    :reader archive)
      (normal     :initarg :normal     :reader normal)
      (temporary  :initarg :temporary  :reader temporary)
     )
   )

(defclass file-system ()
    (
     (path        :initarg :path        :reader path)
     (name        :initarg :name        :reeader name)
     (owner       :initarg :owner       :reader owner)

     (type        :initarg :type        :reader type)
     (create-date :initarg :create-date :reader create-date)
     (write-date  :initarg :write-date  :reader write-date)
     (attribute   :initarg :attribute   :reader attribute)
     )
   )


(defclass file-object (file-system)
    (

     (size        :initarg :size        :reader size)
     )
   )
(defclass directory-object (file-system)
    (
     (child*      :initarg :child*      :accessor child*)
     )
   )
|#

(defun current-directory-path-p (path)
   (string=  (car (last (pathname-directory path)))  ".")
   )

(defun parent-directory-path-p (path)
   (string=  (car (last (pathname-directory path))) "..")
   )

(defun make-fs-object (file)
   (if (file-directory-p file)
      (append
        (make-fs-object* (directory (merge-pathnames "*.*" (truename file))))
        (make-fs-object* (directory (merge-pathnames "*\\" (truename file))))
        )
      (list file )
      )
   )

(defun make-fs-object* (file*)
   (loop for file in file*
     unless (or (current-directory-path-p file) (parent-directory-path-p file))
     append (make-fs-object file)
     )
   )

;(pprint (make-fs-object "."))
;(setf f1 (make-fs-object "K:\\ALLEGRO\\lispwork\\testdir\\"))
;(make-fs-object "K:\\ALLEGRO\\")

#|
(defclassifier
  filelist1
  ()
  (name ()
    (lambda (obj part) (pathname-directory obj))
    t)
  )

;(filebrowser 'filelist1 ".")
(filebrowser 'filelist1  "K:\\ALLEGRO\\lispwork\\objclass\\")
|#

(defun max-level (part)
   (if part
      (loop for parent in (parent* part) maximize (level parent))
      0
      )
   )
#|
(defun my-dir-name (obj part)
   (nth (1+ (max-level part))(pathname-directory obj))
   )

(defun dir-p (obj part)
   (nth (1+ (max-level part)) (pathname-directory obj))
   )
|#
(defun my-dir-name (obj part)
   (nth (level part)(pathname-directory obj))
   )

(defun dir-p (obj part)
   (nth (level part) (pathname-directory obj))
   )
(defun my-level (part obj)
   (setf (level part) (1+ (max-level part)))
   )

(defclassifier
  filelist2
  '((level :initform 0 :accessor level))
  (directory (t directory)
    my-dir-name
    dir-p
    my-level
    )
  )

#|
(defun file-display (file)
 (format t "~A" (file-namestring file))
 )

(setf bag2 (make-classifier 'filelist2))
(put-object bag2  #P"K:\\ALLEGRO\\lispwork\\objclass\objclass.lsp")
(show bag2 'file-display)

(setf bag3 (make-classifier 'filelist2))
(setf files (make-fs-object "K:\\ALLEGRO\\lispwork\\testdir\\"))
(put-object* bag3 files)
(show bag3 'file-display t)
|#
(filebrowser 'filelist2 (current-directory) 'file-namestring)

;(filebrowser 'filelist2  "K:\\ALLEGRO\\lispwork\\" 'file-namestring)
;(filebrowser 'filelist2  "K:\\ALLEGRO\\lispwork\\")
;(filebrowser 'filelist2  "K:\\ALLEGRO\\lispwork\\testdir\\" 'file-namestring)
;(filebrowser 'filelist2  "K:\\ALLEGRO\\lispwork\\testdir\\")


#|
(defclassifier
  filelist3
  '((level :initform 0 :accessor level))
  (directory (t directory)
    (lambda (obj part) (nth (level part)(pathname-directory obj)))
    (lambda (obj part) (nth (level part) (pathname-directory obj)))
    (lambda (part obj) (setf (level part) (1+ (max-level part))))
    )
  )

(filebrowser 'filelist3  (user-homedir-pathname))
;(filebrowser 'filelist3  "K:\\ALLEGRO\\lispwork\\" 'file-namestring)
;(filebrowser 'filelist3  "K:\\ALLEGRO\\lispwork\\")
;(filebrowser 'filelist3  "K:\\ALLEGRO\\lispwork\\testdir\\" 'file-namestring)
;(filebrowser 'filelist3  "K:\\ALLEGRO\\lispwork\\testdir\\")


|#