;;; 1998 Copyright OMURA Shinichi, all rights reserved
;;; test data for Object Classifier cyclic version -- continue

(if (not (string= (lisp-implementation-type) "Macintosh Common Lisp"))
  (require 'object-classifier (merge-pathnames "objclasr.lsp" (current-directory)))
)
;(in-package 'ocp)



#|
10 represenation is string, constraint is t
|#


(defclass document ()
  ((title    :initarg :title    :reader doc-title)
   (lang     :initarg :lang     :reader doc-lang)
   (author   :initarg :author   :reader doc-author)
   (category :initarg :category :reader doc-category)
   (keyword  :initarg :keyword  :reader doc-keyword :initform nil)
   (pub-year :initarg :pub-year :reader doc-pub-year :initform 1997)
   )
  )

(defmethod display ((doc document))
  (format t "{~A by ~A#~A#~A#~S# ~S# ~S}"
    (and (slot-boundp doc 'title) (doc-title doc))
    (and (slot-boundp doc 'author) (doc-author doc))
    (and (slot-boundp doc 'category) (doc-category doc))
    (and (slot-boundp doc 'lang) (doc-lang doc))
    (and (slot-boundp doc 'keyword) (doc-keyword doc))
    (and (slot-boundp doc 'pub-year) (doc-pub-year doc))
    doc
    )
  )


;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(format t "~%;;; case 10 part-form is string, constraint is t~%")

(format t "~%;;case 10 (1)~%~%")

(setf doc101 (list
             (make-instance 'document
               :title     "case 1 book"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )))

(defclassifier
  case101
  nil
  (Author ()
    "OMURA"
    (lambda (x y) (equal (doc-author x) 'OMURA))
    )
  (dummy (author)
    "dummy"
    t
    )
  )

(setf case101d (make-classifier 'case101))
(put-object* case101d doc101)
(show case101d 'display)
(format t "CHECK: /[T]/[OMURA]/[dummy]/{case 1 book#}~%")

