;;; OBJECT CLASSIFIER
#|
(provide 'object-classifier)
(defpackage "object-classifier-package"
  (:nickname 'classifier)
  (:export 
   defclassifier
   make-classifier
   put-object
   put-object*
   get-all-object*
   get-object*
   get-t-category
   get-t-partition
   child*
   get-partition
   )
  )

(in-package 'classifier)
|#

#|
[̃t@C̃VXȅ]
classifier - category - partition ̊KwĂB
̂߁Apartitionchild*ɂ́AقȂcategorypartition
݂ĂB

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SPECIFICATION --- DESCRIPTION

1. Object Classifier ́Aobject𐮗black boxB
   classbrowserŌ悤ɁAobjectclassifierł݂B
   w肷邱ƂĂłB̌́A3categoryŒ`B

2. {Pʂ́Aobject̃ReiłApartitionƌĂԁB
@partitiońA(constraint)𖞂objecti[ĂB
  W_́Aɂ`݂Ȃ̂ȁB

3. partitionԂ̍\`̂categoryƌĂԁB
   categorył́Â̂`B

   0) O             cateogory̖O
   1) constraint       categoryɑobjectɑ΂constraint
   2) representation        categoryinstanceɑobject́ApartitionɍוB
                       lނɕrepresentationłB

   classifieŕAcategoryɂāAЂƂ̃ev[g`B
   Ȃobject낢낢classifierɓĂƂ͂łB
   classifierɂ͎̂Ă킯ł͂ȂAOo^ĂB

4. ʓIȎg̎菇
   1) classifier`B
   2) classifierinstance쐬BꂪAobject̗eꕨłB
   3) classifierobjecto^BclassifieŕAobjectcategoryŒ`ꂽ\
      ĕނAێK؂partition쐬B
   4) classifierɓo^ꂽobject́Apartitionw肷邱ƂɂĎoƂ
      łB
      partitiońAclassifire珇Ԃɂǂ邩Apartitionpathw肷B

5. ̌v

   1) GUIAuEU肽


6. C^[tFCX


;;; classifier̒`
(defclassifier name . category-def*) => classifier

;;; classifierinstance̍쐬
(make-classifier name)) => classifier instance

;;; classifierobjecto^B
(put-object ((cl classifier) object)) ==> object // place it in a fitting place
(put-object* ((cl classifier) object*)) ==> object* // place it in a fitting place

;;; classifierɓo^ꂽׂĂobjectQƂ
(get-all-object* ((cl classifier))) ==> object* // all in cl

;;; partitionƁA̎qpartitionׂ̂Ăɓo^ĂobjectQƂ
(get-all-object* ((pt partition))) ==> object* // all in pt

;;; partitionɒڊ܂܂ĂobjectQƂ
(get-object* ((pt partition))) ==> object* // in pt


;;; classifierɂ́At category, t partition ꂼBÂ
;;; ܂܂Ă
;;; classifierAꂼ t o

(get-t-category ((cl classifier))) ==> category
(get-t-partition ((cl classifier))) ==> partition

;;; partition 炻sub partition o
;; ׂĂ patrition ́At partition 玟methodJԂKp邱Ƃ
;; ǂ邱Ƃł

(child* ((pt partition))) ==> partition*

;;; category 炻sub category o
;; ׂĂcategorýAt category玟methodJԂKp邱Ƃ
;; ǂ邱Ƃł

(child* ((ct category)) ==> category*
 

;;; classifier Apartition path Ŏw肳ꂽpartitiono

(get-partition ((cl classifier) r-path)) ==> partition // is described by r-path


;;; path description
r-path

t is a unique partition of root category.

(t r1 r2 ...)

;;; classifier ɑ邷ׂĂobjectApatthtion path ƂƂ
;;  \method

(show ((cl classifier) method))  ;; o^Ăobjectɑ΂ẮAmethodKpB
                                 ;; ܂Amethod\methodł邱ƂOɂĂ

-----------------------------------------------------------------------------------------
;;;;;;;;;;  history of work
----
1998.04.12 make-classifieŕAmetaclassgāAmake-instance:afterŎs΂悢B
̂悤ɂB

----
1998.04.12 representation ɕƁAg悤ɕύX悤
           constraint  t ƁAtƂȂ悤ɂ悤
1998.04.12 C
make-categoryƂAlambda𐶐悤ɂB
apply͕ςȂB

function^C~Omake-category̒łȂAĂяoƂ
B

satisfy?  partition-name Bapplyɂ̂͂₾B
----
1998.04.10 unionpartitiońAׂĕʌ݂̑ƂȂAunion ɂ͂ȂȂB
test1/case 8 (1)

unition邽߂ɂ́Aput-objecttraverseĂԂ́Aobject
o^ꂽAׂĂ̗(resume)B
āAput-object-subŁAsub partitionTOɁAresume̒
o^łpartition݂ApartƂȂB
child part, child cat ̌ł́Aunion child ͏OB
̂߂ɁAobjectĂ cargo`B
history𓱓AresumeĂ͕ςȂƂmFB
unionł͂ȂAjoinłȂĂ͂ȂȂ݂B
partition ɑƂƂ́Aparentׂ̏Ė
킯AjoinłȂB

 a (b)  a (b b)߂ɂȂȂĂ͂ȂȂ̂Aunion
ōlƂǂĂB

joinłƂƁAobject́Apartɂ邷ׂĂpath
ɂsatisfy?͂Ȃ̂ŁAresume݂Ă΂킩B

resume, sub-partition, sub-categorŷꂼɂă`FbN悤
ɂBAcase 8 ݂ƁA̋@\͂܂ɂȂ
Ƃ킩B
ށB

----
1998.04.10 sub partition łЂƂ݂ƖĂ܂悤B
           \ȂׂĂsub partɓo^悤ɂ悤
case 7(2)
1998.04.12 ׂ݂Ăpartitionɓo^悤ɏC

put-object-sub̓ύXApartcat̗ւ̓o^
悤ɂB


ŏႢldiffgĂBset-difference
-----
1998.04.08 categorypartitionƓ悤ɕׂ
 C1 --> C2

 R11 --> R21 -->R31(C3)
 R12 --> R22 -->R31(C3)
1998.04.12 ͂߂邱Ƃɂ
R
Ԃɑ݂Ȃ΂ȂȂǗobject́Aconstraint1:1̂̂ƁA
partitionɑ΂1:1̗̂̂B
̂A̒ԊǗobject́AKSɕKvȏێłȂB
bgƂ΁Asub partition categoryŕނ邱ƂȂ̂A
Ăǂɗ̂܂ȂB

Ⴆ΁AĂłƍlĂuniońAȂłłĂ܂B
1998.04.12 unionɊւẮAႢĂB

--
1998.04.10 Ȃobject𓯂partitionɏdēo^Ȃ悤ɂ
1998.04.10 test suits9܂ō

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
|#

;;; debug staff

;;; ̃}NLɂƁAg[XƂ

;(defmacro debug (s f &rest a) `(format ,s ,f ,@a))


;;; ̃}NLɂƁAg[X
(defmacro debug (s f &rest a) t)

;;; expression interface layer ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                       classifier߂ utility               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 

(defmethod slot-exists-boundp (object name)
   (and
        (slot-exists-p object name)
        (slot-boundp object name)
        )
   )


;;; category̒`

(defstruct (category-def (:type list))
  name
  parent*                       ;; (null parent*) == (t)
                                ;; parent* ̗vf́A㉺֌Ŵcategory܂ł͂Ȃ
                                ;; ) (t a b c d) ̂Ƃ d parent*(a c)ƂȂ
  representation                     ;; (representation obj)partition̖OɂȂ
                                ;; (stringp partition) Ȃ炻̒lp
  constraint                    ;; (constraint obj)categoryinstanceɑ
                                ;; t ȂtƂ
  )

(defun t? (x) (eq t x))

;;; object layer ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; class definition ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass classifier-class (standard-class)
    (
     (definition*     :initform nil :accessor definition*   )
     (category-table  :initform nil :accessor category-table)
     )
   )

#|
;;; this may be only for FreeLisp...?

(defmethod validate-superclass ((class classifier-class)
				(superclass standard-class))
  t)
|#

(defclass classifier ()
    (
     (t-partition            :initform nil :accessor t-partition)
     )
   (:metaclass classifier-class))

(defclass category ()
  (
   (name            :initarg :name       :initform nil :reader   name)
   (parent*         :initarg :parent*    :initform nil :reader   parent*) ;; category*
   (child*          :initform nil        :accessor child*)  ;; hash for name:category*
   (representation       :initarg :representation  :initform nil :reader   representation)
   (constraint      :initarg :constraint :initform nil :reader   constraint)
   )
  )

;;; there always exists t in every category.
;;; it means otherwise.

(defclass partition ()
  (
   (name      :initarg :name                     :reader   name)
   (parent*   :initform nil  :accessor parent*)  ;; partition*
   (child*    :initform nil  :accessor child*)   ;; partition*
   (category  :initarg :category                 :reader   category)
   (object*   :initform nil  :accessor object*)  ;; any object not satisfy all child*
   (constraint* :initform nil :accessor constraint*) 
   )
  )

(defmethod local-constraint ((part partition))
   (list (constraint (category part))
     `(lambda (obj) (equal (name ,part)
                      (partition-name (category ,part) obj))))
   )


(defmethod initialize-instance :after ((instance partition) &rest args)
   (if (parent* instance)
      (push (loop for parent in (parent* instance) collect
              (append (constraint* parent)
                (local-constraint instance))
              )
        (constraint* instance)
        )
      (setf (constraint* instance) (local-constraint instance)))
   (debug t "make:: ~S : ~S~%" (name instance) (constraint* instance))
   )

#|
;;; class property

 (equal (category (child* part))   ;; category is canonial extended.
        (child* (category part)))

 full constraint of category c : fc(c)Ƃ
 
  fc(t) = t
  fc(c) = fc(b) & (constraint c)   (c (b) ...) 

 full constraint of partition p : fp(p)Ƃ

  fp(t) = t
  fp(p) = fp(p1) & ... & fp(pn) & (constraint (category p)) & 
          (equal (name p) (partition-name (categoyr p) obj)

  ́A֐ &

|#


;;; interface ...................................................................

(defmacro defclassifier (cname &rest category-def* )
   "classifier ̒`s"
  `(let ((category-table (make-hash-table)) category*)
     (setf category* (make-category* ',category-def* category-table))
     (define-classifier
      ,cname
      category-table
      category*
      )
     )
  )

(defmacro define-classifier (cname category-table category*)
  `(let (c)
     (setf c (defclass ,cname (classifier) ()(:metaclass classifier-class)))
     (setf (slot-value c 'definition*) ,category*)
     (setf (slot-value c 'category-table) ,category-table)
     c
     )
  )

(defun put-t-category (category-table) 
   (make-category 
     t 
     nil
     '(lambda (x) "t")
     '(lambda (x)  t)
     category-table)
   )

(defmethod get-t-category ((cl classifier)) 
   (gethash t (category-table (class-of cl)) ))

(defun make-category* (category-def* category-table)
   (cons
     (put-t-category category-table)
     (loop for category-def in category-def* collect
       (make-category
         (category-def-name category-def)
         (let ((parent* (category-def-parent* category-def)))
            ;; I recognize () as (t), and t must be only one
            (if (and (null parent*) (not (eq (category-def-name category-def) t))) 
               (list (gethash t category-table))
               (loop for parent in parent* collect
                 (gethash parent category-table))
               ))
         (let ((pf (category-def-representation  category-def))) ;; I manipulate string form
            (if (stringp pf) `(lambda (x) ,pf) pf))
         
         (let ((ct (category-def-constraint category-def))) ;; I manipulate t for const.
            (if (t? ct) '(lambda (x) t) ct))
         category-table)
       )
     )
   )

(defun make-category (name parent* representation constraint category-table)
  (let (me)
    (setf me (eval `(make-instance      'category
		            :name       ',name
                            :parent*    ',parent*
                            :representation   ',representation
		            :constraint   ',constraint
		            )))
    (set-me-in-parent* name parent* me)     ;; syncronize parent*
    (setf (gethash name category-table) me) ;; syncronize category-table
    )
  )

(defun set-me-in-parent* (name parent* me)
  (loop for parent in parent* do
        (pushnew me (child* parent))
        )
  )

;;; -------------------------------------------------------------------


(defmethod make-t-partition ((cf classifier))
     (make-instance 'partition
       :name t
       :category (get-t-category cf)
       )
   )

(defmethod initialize-instance ((cl classifier) &rest arg)
   :after (setf (t-partition cl) (make-t-partition cl))
   )
   
(defun make-classifier (classifier)
      (make-instance classifier))

#|
;;; type definition -------------------------------------------------

(defun category-list-p (L)
  (loop for e in L always (typep e 'category))
  )

(deftype category-list () '(satisfies category-list-p))

(defun partition-list-p (L)
  (loop for e in L always (typep e 'partition))
  )

(deftype partition-list () '(satisfies partition-list-p))
|#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                           put-object                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; cargo -- avehicle for objects

(defclass cargo ()
    (
     (object   :initarg :object :reader   object)
     (resume   :initform nil    :accessor resume)
     )
   )


(defun put-object* (cf object*)
  (loop for object in object* append
        (put-object cf object))
  )

(defmethod  put-object ((cf classifier) object &optional history)
;;; put the object to  t partition
   (put-object 
     (t-partition cf) 
     (make-instance 'cargo :object object)
     (or history nil)
     )
   )


#|
(defmethod put-object ((container* list) object)
  ;; I place the object in first eligible category in category*
  (loop for container in container* do
        (put-object container object)
        )
  )
|#

(defmethod partition-name ((ct category) object) 
    (apply (representation ct) (list object)))

(defmethod satisfy? ((ct category) object) 
  (apply (constraint ct) (list object)))
    
(defun link-sub* (part sub*)
  (progn
    (loop for sub in sub* do
          (pushnew sub (child* part))
          (pushnew part (parent* sub))
          )
    sub*
    )
   )

(defun get-category* (par*)
   (loop for par in par* collect
     (category par))
   )

(defun add-history (par hist) (append hist (list par)))

(defun add-constraint (child const**)
   (setf (constraint* child)
         (append (constraint* child)
           const**))
   )


(defmethod search-resume ((par partition) history (cg cargo))
   ;; => list of par whose parent* contains (category par)
   (let (subhist)
      (loop for hpar in history 
        when (member (category par) (parent* (category hpar)))
        append
        (let ()
          (add-constraint hpar (constraint* par))
          (debug t "union:: ~S : ~S~%" (name hpar) (constraint* hpar))
          (link-sub* par (list hpar))
           )
        )
      )
   )
                          
(defmethod put-object-union ((par partition) (cg cargo))   
   ;; sub partitionTOɁAresume̒ɓo^łpartition݂A
   ;; partƂȂB
   ;; child part, child cat ̌ł́Aunion child ͏OB
   (loop for history in (resume cg) append 
     (search-resume par history cg)
     )
   )
    
(defun put-object-sub-partition (par cg history u-sub*)
  (loop for sub in (set-difference (child* par) u-sub*)
        when (and (satisfy? (category sub) (object cg))
                  (equal (name sub) (partition-name (category sub) (object cg)))
                  (full-satisfy? sub (object cg))
                  (put-object sub cg (add-history par history)))
        append (list sub))
  )

(defun already-spawned  (par ct cg)
   (loop for child in (child* par) 
     thereis 
     (if (equal ct (category child) ) (full-satisfy? child (object cg)))
     )
   )

(defun put-object-sub-category (par cg history)
  (let (sub*)
    (loop for sct in (child* (category par)) 
          when (and (satisfy? sct (object cg))
                    (not (already-spawned par sct cg))
                    (setf sub* (put-object sct cg (add-history par history))))
      append (link-sub* par sub*)
      )
     )
   )

(defmethod put-object-sub ((par partition) (cg cargo)  &optional history)
   ;; par  child* ̒ŁA category ł݂Ƃ (object cg)  name 
   ;; AA category  constraint ݂́B
   (let (u-sub*)
      (append
        (setf u-sub* (put-object-union par cg))
        (put-object-sub-partition par cg history u-sub*)
        (put-object-sub-category par cg history)
        )
      )
   )

(defmethod entry-object ((par partition) (cg cargo) history)
   (let ()
      (pushnew (object cg) (object* par))
      (push (add-history par history) (resume cg))
      (debug t "resume: ~S   history: ~S~%" (resume cg) history)
      )
   )

(defmethod put-object ((par partition) (cg cargo) &optional history)
   (let ()
      (debug t "~A/" (name par))
      (if (satisfy? (category par) (object cg))
         (let ((sub* (put-object-sub par cg history)))
            (if (null sub*)
               (let ()
                  (debug t "{put object ~S in ~A}~%" cg (name par))
                  (entry-object par cg history)
                  (debug t "object* = ~S~%" (object* par))
                  )
               )
            (list par)
            )
         )
      )
   )


(defmethod put-object ((ct category) (cg cargo)  &optional history)
   ;; This method is called only when no partition for object exists in ct 
   (if (satisfy? ct (object cg))
      (let (name)
         (setf name (partition-name ct (object cg)))
         (put-object
             (make-instance 'partition
               :name name
               :category ct
               )
           cg
           history)
         )
      )
   )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                           about category                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmethod get-category ((cl classifier))
  (gethash t (category-table (class-of cl)) ))

(defmethod get-sub-category* ((ct category)) (child* ct))

;;;

(defmethod show-category ((cl classifier) &optional indent)
   (terpri t)
   (show-category (get-category cl) (or indent 0))
   )

(defmethod show-category ((ct category) &optional indent)
  (progn
    (format t "~A/[~A]~%" (nspace indent) (name ct))
    (loop for c in (child* ct) do
          (show-category c (1+ indent))
          )
    )
  )



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                           get-object*                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmethod get-object* ((part partition)) (object* part))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                           get-all-object*                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmethod get-t-partition ((cl classifier)) (t-partition cl))

(defmethod get-all-object* ((cl classifier)) (get-all-object* (get-t-partition cl)))

(defmethod get-all-object* ((pat partition))
   ;;I collect the all objects that the tree whose t-partition is pat contains
   (append (object* pat)
     (loop for c in (child* pat) append
       (get-all-object* c)
       )
     )
   )

;; test
#|
(mapcar #'(lambda (x) (progn (display x)(terpri t))) 
        (get-all-object* tree1))
|#
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                show                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmethod show ((cl classifier) method &optional detail indent)
  (let ((t-partition (get-t-partition cl)))
    (and t-partition (show t-partition method detail (or indent 0) ))
    )
  )

(defmethod show ((re partition) method &optional detail indent )
  (progn
    (if detail
       (format t "~A[~A]~S/~%" (nspace indent) (name re) re)       
       (format t "~A[~A]/~%" (nspace indent) (name re))
       )
    (loop for obj in (object* re) do
          (format t "~A" (nspace (1+ indent)))
          (apply method (list obj) )
          (terpri t)
          )
    (loop for c in (child* re) do
          (show c method detail (1+ indent) )
          )
    )
  )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                            show-partition                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmethod show-partition ((cl classifier) &optional indent)
   (terpri t)
   (show-partition (get-t-partition cl) (or indent 0))
   )

(defmethod show-partition ((re partition) &optional indent)
   (prog ((sp (or indent 0)))
     (format t "~A/~A~%" (nspace sp) (name re))
     (loop for sub in (child* re) do
       (show-partition sub (1+ sp))
       )
     )
   )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                          system utility                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun nspace (n) (check-type n integer) 
       (make-sequence 'string n :initial-element #\  ))

(defmethod contain? ((part partition) object)
   (or (member object (object* part))
      (loop for child in (child* part) thereis
            (contain? child object))
      )
  )

(defmethod satisfy? ((part partition) object) 
  (and (satisfy? (category part) object)
           (equal (name part)
                      (partition-name (category part) object))
           (loop for parent in (parent* part) always
                    (satisfy? parent object)))
   )

(defun full-satisfy? (part obj)
   ;; constraint*́Apartitionfull constraint.
   ;; join Ăparent̐ApathƂconstraint*ł
   (loop for fn in (constraint* part) always
         (funcall fn  obj)
     )
   )
