/* 
* I2C.cpp
*
* Created: 2014/06/21 14:04:25
* Author: SIMON
*/

#ifndef _I2C
#define _I2C

#include "I2C.h"

// default constructor
I2C::I2C()
{
} //I2C

void I2C::SetWriteAddress(unsigned char _WriteAddress){
	Address = _WriteAddress;
}

void I2C::SetOwnAddress(unsigned char _OwnAddress, unsigned char EnGeneralCall){
	TWAR = ((_OwnAddress << 1) | EnGeneralCall);
}

void I2C::SetBR(unsigned char _BR,unsigned char _PS){
	TWBR = _BR;
	if (_PS == 1){
		TWSR &= 0xFC;
	}else if (_PS == 4){
		TWSR &= 0xFD;
	}else if (_PS == 16){
		TWSR &= 0xFE;
	}else{
		TWSR &= 0xFC;
	}
}

void I2C::EnI2C(){
	TWCR |= 0x44;
}

void I2C::ClearIntFlag(){
	TWCR |= 0x80;
}

void I2C::CheckAndClearIntFlag(){
	if (CheckIntFlag() == 1){
		ClearIntFlag();
	}
}

void I2C::LoopUntilFlagSet(){
	while(CheckIntFlag() != 1);
}

void I2C::Start(){
	TWCR |= 0x20;
}

void I2C::Stop(){
	TWCR |= 0x10;
}

unsigned char I2C::ShiftStatus(){
	unsigned char val;
	val = ((TWSR >> 3) & 0x1F);
	return val;
}

unsigned char I2C::WriteAddress(unsigned char _RW){
	unsigned char val;
	CheckAndClearIntFlag();
	TWDR = ((Address << 1) | _RW);
	Start();
	LoopUntilFlagSet();
	CheckAndClearIntFlag();
	Stop();
	if (ShiftStatus() == 0x03){
		val = 1;
	}else if (ShiftStatus() == 0x04;){
		val = 0;
	}
	return val;
}

unsigned char I2C::Write(unsigned char _Data){
	unsigned char val;
	unsigned char RxAck;
	RxAck = WriteAddress(0);
	if (RxAck == 1){
		val = 1;
		CheckAndClearIntFlag();
		TWDR = _Data;
		Start();
		LoopUntilFlagSet();
		CheckAndClearIntFlag();
		Stop();
		if (ShiftStatus() == 0x05){
			val = 1;
		}else if (ShiftStatus() == 0x06){
			val = 0;
		}
	}else if (RxAck == 0){
		val = 0;
	}
	return val;
}


unsigned char I2C::CheckIntFlag(){
	unsigned char val;
	if (TWCR & 0x80 == 0x80){
		val = 1;
	}else{
		val = 0;
	}
	return val;
}

// default destructor
I2C::~I2C()
{
} //~I2C

#endif