/*
 * InPort.cpp
 *
 *  Created on: 2014/06/12
 *      Author: simon
 */

#ifndef _InPort
#define _InPort

#include "InPort.h"
#include <avr/io.h>
#include <util/delay.h>

InPort::InPort(){

}

void InPort::Set(unsigned char _Port, unsigned char _Num){

	Port = _Port;
	Num = _Num;

#ifdef PortA
	if (Port == 'A'){
		DDRA &= ~(Parse.Num2Pin(Num));
	}
#endif

#ifdef PortB
	if (Port == 'B'){
		DDRB &= ~(Parse.Num2Pin(Num));
	}
#endif

#ifdef PortC
	if (Port == 'C'){
		DDRC &= ~(Parse.Num2Pin(Num));
	}
#endif

#ifdef PortD
	if (Port == 'D'){
		DDRD &= ~(Parse.Num2Pin(Num));
	}
#endif

	PastState = Read();

}

void InPort::SetPullUp(){
	#ifdef PortA
	if (Port == 'A'){
		PORTA |= Parse.Num2Pin(Num);
	}
	#endif
	
	#ifdef PortB
	if (Port == 'B'){
		PORTB |= Parse.Num2Pin(Num);
	}
	#endif
	
	#ifdef PortC
	if (Port == 'C'){
		PORTC |= Parse.Num2Pin(Num);
	}
	#endif
	
	#ifdef PortD
	if (Port == 'A'){
		PORTD |= Parse.Num2Pin(Num);
	}
	#endif
}


unsigned char InPort::Read(){
unsigned char val = 0;

#ifdef PortA
	if (Port == 'A'){
		if ((PINA & (Parse.Num2Pin(Num))) == (Parse.Num2Pin(Num))){
			val = 1;
		}else{
			val = 0;
		}
	}
#endif

#ifdef PortB
	if (Port == 'B'){
		if ((PINB & (Parse.Num2Pin(Num))) == (Parse.Num2Pin(Num))){
			val = 1;
		}else{
			val = 0;
		}
	}
#endif

#ifdef PortC
	if (Port == 'C'){
		if ((PINC & (Parse.Num2Pin(Num))) == (Parse.Num2Pin(Num))){
			val = 1;
		}else{
			val = 0;
		}
	}
#endif

#ifdef PortD
	else if (Port == 'D'){
		if ((PIND & (Parse.Num2Pin(Num))) == (Parse.Num2Pin(Num))){
			val = 1;
		}else{
			val = 0;
		}
	}
#endif

	return val;
}

unsigned char InPort::RiseOrFall(){
	unsigned char val = 2;
	if (PastState == 0){
		if (Read() == 1){
			val = 1;
			PastState = 1;
		}
	}else if (PastState == 1){
		if (Read() == 0){
			val = 0;
			PastState = 0;
		}
	}
	return val;
}

unsigned char InPort::RiseOrFallCC(){
	unsigned char val = 2;
	if (PastState == 0){
		if (Read() == 1){
			_delay_ms(3);
			if (Read() == 1){
				val = 1;
				PastState = 1;
			}
		}
	}else if (PastState == 1){
		if (Read() == 0){
			_delay_ms(3);
			if (Read() == 0){
				val = 0;
				PastState = 0;
			}
		}
	}
	return val;
}

unsigned char InPort::Rise(){
	unsigned char val = 0;
	if (PastState == 0){
		if (Read() == 1){
			val = 1;
			PastState = 1;
		}
	}else{
		val = 0;
	}
	return val;
}

unsigned char InPort::Fall(){
	unsigned char val = 0;
	if (Read() == 0){
		if (PastState == 1){
			val = 1;
			PastState = 0;
		}
	}else{
		val = 0;
	}
	return val;
}

unsigned char InPort::RiseCC(){
	unsigned char val = 0;
	if (PastState == 0 ){
		if (Read() == 1){
			_delay_ms(3);
			if (Read () == 1){
				PastState = 1;
				val = 1;
			}
		}
	}else{
		val = 0;
	}
	return val;
}

unsigned char InPort::FallCC(){
	unsigned char val = 0;
	if (PastState == 1 ){
		if (Read() == 0){
			_delay_ms(3);
			if (Read () == 0){
				PastState = 0;
				val = 1;
			}
		}
	}else{
		val = 0;
	}
	return val;
}

#endif


