/*
 * NJM1159.cpp
 *
 *  Created on: 2014/06/12
 *      Author: simon
 */
#ifndef _NJM1159
#define _NJM1159

#include "NJM1159.h"

#include <avr/io.h>
#include <util/delay.h>
#include "OutPort.cpp"

NJM1159::NJM1159() {

}

void NJM1159::Set(unsigned char LatchP,unsigned char LatchPNum,unsigned char ClkP,unsigned char ClkPNum, unsigned char DataP,unsigned char DataPNum){

	LatchPin.Set(LatchP,LatchPNum);
	ClkPin.Set(ClkP,ClkPNum);
	DataPin.Set(DataP,DataPNum);

}


void NJM1159::Write(unsigned char _Data, unsigned char _Address, unsigned char _Ch){

	ClkPin.High();
	LatchPin.Low();
	
	for (int i = 6; i >= 0; i--){
		ClkPin.High();
		DataPin.Write((_Data >> i) & 0x01);
		_delay_us(4);
		ClkPin.Low();
		_delay_us(4);
	}
	
	_delay_us(8); //D8のインターバル

	//D7 D6 D5 送信
	DataPin.Low();
	for (int i = 0; i < 3; i++){
		ClkPin.High();
		_delay_us(4);
		ClkPin.Low();
		_delay_us(4);
	}

	//D4 (Channnell) 送信
	if (_Ch == 1){
		DataPin.Low();
		ClkPin.High();
		_delay_us(4);
		ClkPin.Low();
		_delay_us(4);
	}
	
	else if (_Ch == 2){
		DataPin.High();
		ClkPin.High();
		_delay_us(4);
		ClkPin.Low();
		_delay_us(4);
	}

	//Chip Address 送信
	DataPin.Low();
	for (int i = 0; i < 2; i++){
		ClkPin.High();
		_delay_us(4);
		ClkPin.Low();
		_delay_us(4);
	}

	for (int i = 1; i >= 0 ; i--){
			DataPin.Write((_Address >> i) & 0x01);
			ClkPin.High();
			_delay_us(4);
			ClkPin.Low();
			_delay_us(4);
		}


	DataPin.Low();
	ClkPin.High();
	_delay_us(4);

	LatchPin.High();
	_delay_us(8);
	LatchPin.Low();
}

#endif
