/*
 * OutPort.cpp
 *
 *  Created on: 2014/06/12
 *      Author: simon
 */
#ifndef _OutPort
#define _OutPort

#include "OutPort.h"
#include <avr/io.h>

OutPort::OutPort() {

}

void OutPort::Set(unsigned char _Port, unsigned char _Num){

	Num = _Num;
	Port = _Port;

#ifdef PortA
	if (Port == 'A'){
		DDRA |= Parse.Num2Pin(Num);
	}
#endif

#ifdef PortB
	if (Port == 'B'){
		DDRB |= Parse.Num2Pin(Num);
	}
#endif

#ifdef PortC
	if (Port == 'C'){
		DDRC |= Parse.Num2Pin(Num);
	}
#endif

#ifdef PortD
	if (Port == 'D'){
		DDRD |= Parse.Num2Pin(Num);
	}
#endif
}

void OutPort::Write(unsigned char val){
	if (val == 1){
		High();
	}
	else if (val == 0){
		Low();
	}
}

void OutPort::High(){
#ifdef PortA
	if (Port == 'A'){
		PORTA |= Parse.Num2Pin(Num);
	}
#endif

#ifdef PortB
	if (Port == 'B'){
		PORTB |= Parse.Num2Pin(Num);
	}
#endif

#ifdef PortC
	if (Port == 'C'){
		PORTC |= Parse.Num2Pin(Num);
	}
#endif

#ifdef PortD
	if (Port == 'D'){
		PORTD |= Parse.Num2Pin(Num);
	}
#endif
}

void OutPort::Low(){
#ifdef PortA
	if (Port == 'A'){
		PORTA &= ~(Parse.Num2Pin(Num));
	}
#endif

#ifdef PortB
	if (Port =='B'){
		PORTB &= ~(Parse.Num2Pin(Num));
	}
#endif

#ifdef PortC
	if (Port =='C'){
		PORTC &= ~(Parse.Num2Pin(Num));
	}
#endif

#ifdef PortD
	if (Port =='D'){
		PORTD &= ~(Parse.Num2Pin(Num));
	}
#endif
}

#endif
