/*
 * RotaryEncorder.cpp
 *
 *  Created on: 2014/06/12
 *      Author: simon
 */
#ifndef _RotaryEncorder
#define _RotaryEncorder

#include "RotaryEncorder.h"

#include <avr/io.h>
#include <util/delay.h>

RotaryEncorder::RotaryEncorder() {
	A = 1;
	B = 1;
	ARiseAndFall = 0;
	BRiseAndFall = 0;
	AFall = 0;
	BFall = 0;
	Rotation = 2;

}

void RotaryEncorder::Set(unsigned char AP, unsigned char APNum, unsigned char BP, unsigned char BPNum){
	PhaseA.Set(AP,APNum);
	PhaseB.Set(BP,BPNum);
}

unsigned char RotaryEncorder::GetAState(){

	unsigned char val;
	if (PhaseA.Read() == 1){
		val = 1;
	}else{
		val = 0;
	}
	return val;
}

unsigned char RotaryEncorder::GetBState(){

	unsigned char val;
	if (PhaseB.Read() == 1){
		val = 1;
	}else{
		val = 0;
	}
	return val;
}


unsigned char RotaryEncorder::GetEncorderRotation(){

	A = PhaseA.Read();
	B = PhaseB.Read();

	ARiseAndFall = PhaseA.RiseOrFallCC();
	BRiseAndFall = PhaseB.RiseOrFallCC();

	if ((ARiseAndFall == 1) && (B == 0)){
		Rotation = 0;
	}
	else if ((ARiseAndFall == 0) && (B == 1)){
		Rotation = 0;
	}
	else if ((ARiseAndFall == 1) && (B == 1)){
		Rotation = 1;
	}
	else if ((ARiseAndFall == 0) && (B == 0)){
		Rotation = 1;
	}
	else if ((BRiseAndFall == 1) && (A== 1)){
		Rotation = 0;
	}
	else if ((BRiseAndFall == 0) && (A == 0)){
		Rotation = 0;
	}
	else if ((BRiseAndFall == 1) && (A == 0)){
		Rotation = 1;
	}
	else if ((BRiseAndFall == 0) && (A == 1)){
		Rotation = 1;
	}
	else{
		Rotation = 2;
	}

	return Rotation;
	//return AFall;
	//return 2;
	//return APNum;
}


unsigned char RotaryEncorder::CheckAChattering(){
	_delay_ms(3);
	return GetAState();
}

unsigned char RotaryEncorder::CheckBChattering(){
	_delay_ms(3);
	return GetBState();
}

#endif
