/*
 * Uart.cpp
 *
 *  Created on: 2014/06/12
 *      Author: simon
 */
#ifndef _Uart
#define _Uart

#include "Uart.h"
#include <avr/io.h>

Uart::Uart() {
}

unsigned char Uart::TransPre(){
	unsigned char val;
	
	#ifdef UART
	if ((UCSRA & 0x20) == 0x20){
		val = 1;
	}else{
		val = 0;
	}
	#endif
	
	#ifdef UART0
	if ((UCSR0A & 0x20) == 0x20){
		val = 1;
		}else{
		val = 0;
	}
	#endif
	
	#ifdef UART1
	if ((UCSR1A & 0x20) == 0x20){
		val = 1;
		}else{
		val = 0;
	}
	#endif
	
	return val;
}

unsigned char Uart::Recieved(){
	unsigned char val;
	
	#ifdef UART
	if ((UCSRA & 0x80) == 0x80){
		val = 1;
	}else{
		val = 0;
	}
	#endif
	
	#ifdef UART0
	if ((UCSR0A & 0x80) == 0x80){
		val = 1;
		}else{
		val = 0;
	}
	#endif
	
	#ifdef UART1
	if ((UCSR1A & 0x80) == 0x80){
		val = 1;
		}else{
		val = 0;
	}
	#endif
	
	return val;
}

unsigned char Uart::Read(){
	unsigned char val;
	if (Recieved() == 1){
		#ifdef UART
		val = UDR;
		#endif
		
		#ifdef UART0
		val = UDR0;
		#endif
		
		#ifdef UART1
		val = UDR1;
		#endif
	}
	return val;
}

void Uart::EnUart(){
	
	#ifdef UART
	UCSRB = 0x18;
	UCSRC = 0x06;
	#endif
	
	#ifdef UART0
	UCSR0B = 0x18;
	UCSR0C = 0x06;
	#endif
	
	#ifdef UART1
	UCSR1B = 0x18;
	UCSR1C = 0x06;
	#endif
}

void Uart::SetBaud(unsigned short Resister){
	
	#ifdef UART
	UBRRL = Resister & 0xFF;
	UBRRH = Resister >> 8;
	#endif
	
	#ifdef UART0
	UBRR0L = Resister & 0xFF;
	UBRR0H = Resister >> 8;
	#endif
	
	#ifdef UART1
	UBRR1L = Resister & 0xFF;
	UBRR1H = Resister >> 8;
	#endif
	
}

void Uart::WriteChar(unsigned char data){
	#ifdef UART
	UDR = data;
	#endif
	
	#ifdef UART0
	UDR0 = data;
	#endif
	
	#ifdef UART1
	UDR1 = data;
	#endif
}

void Uart::WriteCharStream(unsigned char data){
	if (TransPre() == 1){
		WriteChar(data);
	}
	//_delay_ms(100);
}

void Uart::WriteStringStream(const char *data){
	while (*data != '\0'){
		if (TransPre() == 1){
			WriteChar(*data);
			data++;
		}
	}
}

void Uart::WriteReturn(){
	WriteCharStream('\n');
	WriteCharStream('\r');
}

#endif
