type t =
    [ `Ascii | `Binary | `Euc | `Jis | `Sjis | `Unknown | `Utf16 | `Utf8 ]
(** The type of character encodings *)

external nkf : string -> string -> string = "ocaml_nkf_kconv"
(** [nkf opt str] converts the [str] string with the given [opt] options. *)

external guess : string -> string = "ocaml_nkf_guess"
(** Guess the character encoding of the given string. 
    Return the encoding name.*)

external nkf_version : unit -> string = "ocaml_nkf_nkf_version"
(** Return the version of nkf. *)

external version : unit -> string = "ocaml_nkf_version"
(** Return something. *)

val guess_t : string -> t
(** Same as {!Nkf.guess} but return the encoding type. *)
