open Printf

let maxcol = 70

let col = ref 2

let print_leading () =
  print_string "let _ = \"\\\n  "

let print_succeeding () =
  print_endline "\""

let nl_and_indent () =
  print_string "\\\n  ";
  col := 2

let newline () =
  if !col > maxcol then
    nl_and_indent ()

let print_1 c =
  let code = int_of_char c in
    if code = 32 then begin
      print_string "\\ ";
      col := !col + 2
    end else if code = 34 then begin
      print_string "\\\"";
      col := !col + 2
    end else if code = 92 then begin
      print_string "\\\\";
      col := !col + 2
    end else if 33 <= code && code <= 126 then begin
      print_char c;
      incr col
    end else begin
      printf "\\%03d" code;
      col := !col + 4
    end

let print s =
  let len = String.length s in
  let rec loop n =
    if n < len then begin
      newline ();
      print_1 s.[n];
      loop (n + 1)
    end
  in
    loop 0

let main () =
  let rec loop () =
    let s, eof = try read_line (), false with End_of_file -> "", true in
      if not eof then begin
        print s;
        loop ()
      end
  in
    print_leading ();
    loop ();
    print_succeeding ()

let _ = main ()
