/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

/*
 * This is a modified version of GtkNotebook from GTK+-2.2.1 by the
 * Ochusha Project.  See the AUTHORS file for a list of people on the
 * Ochusha Project.  See the ChangeLog files for a list of changes.
 * These files are distributed with ochusha at
 * http://home.att.ne.jp/wood/fuyu/.
 *
 * Since libmodifiedgtk2 only has limited set of modified widgets and
 * is intended to be used with original GTK+, I don't want to cause name
 * space conflictions with original widget sets from GTK+.  Therefore,
 * ALL PUBLICLY AVAILABLE NAMES ARE RENAMED.
 *
 * $Id: mod_notebook.h,v 1.1.1.1 2003/05/10 16:34:29 fuyu Exp $
 */

#ifndef __MOD_NOTEBOOK_H__
#define __MOD_NOTEBOOK_H__


#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MOD_TYPE_NOTEBOOK                  (mod_notebook_get_type ())
#define MOD_NOTEBOOK(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOD_TYPE_NOTEBOOK, ModNotebook))
#define MOD_NOTEBOOK_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), MOD_TYPE_NOTEBOOK, ModNotebookClass))
#define MOD_IS_NOTEBOOK(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOD_TYPE_NOTEBOOK))
#define MOD_IS_NOTEBOOK_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), MOD_TYPE_NOTEBOOK))
#define MOD_NOTEBOOK_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), MOD_TYPE_NOTEBOOK, ModNotebookClass))


typedef struct _ModNotebook       ModNotebook;
typedef struct _ModNotebookClass  ModNotebookClass;
typedef struct _ModNotebookPage   ModNotebookPage;

struct _ModNotebook
{
  GtkContainer container;
  
  ModNotebookPage *cur_page;
  GList *children;
  GList *first_tab;		/* The first tab visible (for scrolling notebooks) */
  GList *focus_tab;
  
  GtkWidget *menu;
  GdkWindow *event_window;

  ModNotebookPage *active_tips_page;
  GtkWidget *tip_window;
  GtkWidget *tip_label;
  gint timer_tag;
  GTimeVal last_popdown;
  
  guint32 timer;
  
  guint16 tab_hborder;
  guint16 tab_vborder;

  guint32 minimum_tab_label_size;
  
  guint show_tabs          : 1;
  guint homogeneous        : 1;
  guint show_border        : 1;
  guint tab_pos            : 2;
  guint scrollable         : 1;
  guint in_child           : 2;
  guint click_child        : 2;
  guint button             : 2;
  guint need_timer         : 1;
  guint child_has_focus    : 1;
  guint have_visible_child : 1;
  guint focus_out          : 1;	/* Flag used by ::move-focus-out implementation */
  guint tab_shrinkable     : 1;
  guint enable_tooltips    : 1;
  guint use_sticky_delay   : 1;
  guint delay              : 30;
};

struct _ModNotebookClass
{
  GtkContainerClass parent_class;
  
  void (* switch_page)       (ModNotebook     *notebook,
                              ModNotebookPage *page,
			      guint            page_num);

  /* Action signals for keybindings */
  gboolean (* select_page)     (ModNotebook       *notebook,
                                gboolean           move_focus);
  gboolean (* focus_tab)       (ModNotebook       *notebook,
                                GtkNotebookTab     type);
  void (* change_current_page) (ModNotebook       *notebook,
                                gint               offset);
  void (* move_focus_out)      (ModNotebook       *notebook,
				GtkDirectionType   direction);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

/***********************************************************
 *           Creation, insertion, deletion                 *
 ***********************************************************/

GType   mod_notebook_get_type       (void) G_GNUC_CONST;
GtkWidget * mod_notebook_new        (void);
void mod_notebook_append_page       (ModNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label);
void mod_notebook_append_page_menu  (ModNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label,
				     GtkWidget   *menu_label);
void mod_notebook_prepend_page      (ModNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label);
void mod_notebook_prepend_page_menu (ModNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label,
				     GtkWidget   *menu_label);
void mod_notebook_insert_page       (ModNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label,
				     gint         position);
void mod_notebook_insert_page_menu  (ModNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label,
				     GtkWidget   *menu_label,
				     gint         position);
void mod_notebook_remove_page       (ModNotebook *notebook,
				     gint         page_num);

/***********************************************************
 *            query, set current NotebookPage              *
 ***********************************************************/

gint       mod_notebook_get_current_page (ModNotebook *notebook);
GtkWidget* mod_notebook_get_nth_page     (ModNotebook *notebook,
					  gint         page_num);
gint       mod_notebook_get_n_pages      (ModNotebook *notebook);
gint       mod_notebook_page_num         (ModNotebook *notebook,
					  GtkWidget   *child);
void       mod_notebook_set_current_page (ModNotebook *notebook,
					  gint         page_num);
void       mod_notebook_next_page        (ModNotebook *notebook);
void       mod_notebook_prev_page        (ModNotebook *notebook);

/***********************************************************
 *            set Notebook, NotebookTab style              *
 ***********************************************************/

void     mod_notebook_set_show_border      (ModNotebook     *notebook,
					    gboolean         show_border);
gboolean mod_notebook_get_show_border      (ModNotebook     *notebook);
void     mod_notebook_set_show_tabs        (ModNotebook     *notebook,
					    gboolean         show_tabs);
gboolean mod_notebook_get_show_tabs        (ModNotebook     *notebook);
void     mod_notebook_set_tab_pos          (ModNotebook     *notebook,
				            GtkPositionType  pos);
GtkPositionType mod_notebook_get_tab_pos   (ModNotebook     *notebook);

void     mod_notebook_set_scrollable       (ModNotebook     *notebook,
					    gboolean         scrollable);
gboolean mod_notebook_get_scrollable       (ModNotebook     *notebook);

void     mod_notebook_set_tab_shrinkable   (ModNotebook     *notebook,
					    gboolean         shrinkable);
gboolean mod_notebook_get_tab_shrinkable   (ModNotebook     *notebook);

void     mod_notebook_set_minimum_tab_label_size (ModNotebook *notebook,
						  guint        size);
guint    mod_notebook_get_minimum_tab_label_size (ModNotebook *notebook);

/***********************************************************
 *               enable/disable PopupMenu                  *
 ***********************************************************/

void mod_notebook_popup_enable  (ModNotebook *notebook);
void mod_notebook_popup_disable (ModNotebook *notebook);

/***********************************************************
 *               enable/disable Tooltips for Tabs          *
 ***********************************************************/

void mod_notebook_tooltips_enable  (ModNotebook *notebook);
void mod_notebook_tooltips_disable (ModNotebook *notebook);

/***********************************************************
 *             query/set NotebookPage Properties           *
 ***********************************************************/

GtkWidget * mod_notebook_get_tab_label    (ModNotebook *notebook,
					   GtkWidget   *child);
void mod_notebook_set_tab_label           (ModNotebook *notebook,
					   GtkWidget   *child,
					   GtkWidget   *tab_label);
void mod_notebook_set_tab_label_text      (ModNotebook *notebook,
					   GtkWidget   *child,
					   const gchar *tab_text);
G_CONST_RETURN gchar *mod_notebook_get_tab_label_text (ModNotebook *notebook,
						       GtkWidget   *child);
GtkWidget * mod_notebook_get_menu_label   (ModNotebook *notebook,
					   GtkWidget   *child);
void mod_notebook_set_menu_label          (ModNotebook *notebook,
					   GtkWidget   *child,
					   GtkWidget   *menu_label);
void mod_notebook_set_menu_label_text     (ModNotebook *notebook,
					   GtkWidget   *child,
					   const gchar *menu_text);
G_CONST_RETURN gchar *mod_notebook_get_menu_label_text (ModNotebook *notebook,
							GtkWidget   *child);
void mod_notebook_query_tab_label_packing (ModNotebook *notebook,
					   GtkWidget   *child,
					   gboolean    *expand,
					   gboolean    *fill,
					   GtkPackType *pack_type);
void mod_notebook_set_tab_label_packing   (ModNotebook *notebook,
					   GtkWidget   *child,
					   gboolean     expand,
					   gboolean     fill,
					   GtkPackType  pack_type);
void mod_notebook_reorder_child           (ModNotebook *notebook,
					   GtkWidget   *child,
					   gint         position);
gint mod_notebook_get_mouse_event_page_num (ModNotebook *notebook,
					   GdkEventAny *event);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MOD_NOTEBOOK_H__ */
