/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: response_editor.h,v 1.3 2003/11/04 07:59:09 fuyu Exp $
 */

#ifndef _RESPONSE_EDITOR_H_
#define _RESPONSE_EDITOR_H_

#include "ochusha.h"
#include "ochusha_bbs_thread.h"

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define RESPONSE_EDITOR_TYPE			(response_editor_get_type())
#define RESPONSE_EDITOR(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), RESPONSE_EDITOR_TYPE, ResponseEditor))
#define RESPONSE_EDITOR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), RESPONSE_EDITOR_TYPE, ResponseEditorClass))
#define IS_RESPONSE_EDITOR(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), RESPONSE_EDITOR_TYPE))
#define IS_RESPONSE_EDITOR_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE(klass), RESPONSE_EDITOR_TYPE)
#define RESPONSE_EDITOR_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), RESPONSE_EDITOR_TYPE, ResponseEditorClass))


typedef struct _ResponseEditor ResponseEditor;
typedef struct _ResponseEditorClass ResponseEditorClass;


struct _ResponseEditor
{
  GtkVBox container;

  /* containerȤhboxtext_view */
  GtkBox *hbox;

  /* hboxȤname_combomail_comboȤդ٥ */
  GtkCombo *name_combo;
  GtkCombo *mail_combo;

  GtkTextView *text_view;

  GList *name_list;
  GList *mail_list;

  OchushaBBSThread *thread;
};


struct _ResponseEditorClass
{
  GtkVBoxClass parent_class;
};


GType response_editor_get_type(void);

GtkWidget *response_editor_new(OchushaBBSThread *thread);

const gchar *response_editor_get_name(ResponseEditor *editor);
void response_editor_set_name(ResponseEditor *editor, const gchar *name);
void response_editor_add_name(ResponseEditor *editor, const gchar *name);

const gchar *response_editor_get_mail(ResponseEditor *editor);
void response_editor_set_mail(ResponseEditor *editor, const gchar *mail);
void response_editor_add_mail(ResponseEditor *editor, const gchar *name);

gchar *response_editor_get_response(ResponseEditor *editor);
#if 0
void response_editor_set_response(ResponseEditor *editor,
				  const gchar *response);
#endif


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _RESPONSE_EDITOR_H_ */
