/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha.h,v 1.4 2003/11/20 00:48:25 fuyu Exp $
 */

#ifndef _OCHUSHA_H_
#define _OCHUSHA_H_

#include "config.h"

#include <glib.h>
#include <iconv.h>

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#define OCHUSHA_BOARDLIST_XML		"boardlist.xml"
#define OCHUSHA_CONFIG_XML		"config.xml"
#define OCHUSHA_THREADLIST_XML		"threadlist.xml"

#define OCHUSHA_USER_AGENT		"Monazilla/1.00 (Ochusha/" VERSION ")"

/*
 * ʲĤ2ch˰¸ƤΤǡ̤ξΤ˾
 * 櫡ġ
 */
#define OCHUSHA_DEFAULT_BBSMENU_URL	"http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html"
#define OCHUSHA_SUBJECT_TXT		"subject.txt"
#define OCHUSHA_SUBBACK_HTML		"subback.html"
#define MAX_RESPONSE			1024


typedef struct _OchushaConfig OchushaConfig;


/*
 * Ū˴ؤΤɤ
 */
struct _OchushaConfig
{
  /* ochushaΥ桼ۡǥ쥯ȥؤPATH̾(ɸǤ$HOME/.ochusha) */
  char *home;


  /* İμѤURL: 2ch¸ʤΤ;ɤ٤⤷ */
  char *bbsmenu_url;


  /* proxyϢ */
  char *proxy_url;
  char *proxy_user;
  char *proxy_password;
  gboolean enable_proxy;
  gboolean enable_proxy_auth;


  /* network˥åȤ̤ */
  gboolean offline;
};


/*
 * OCHUSHA_HOMEϢ
 */
void ochusha_config_prepare_home(OchushaConfig *config);
char *ochusha_config_find_file(const OchushaConfig *config,
			       const char *filename);
int ochusha_config_open_file(const OchushaConfig *config, const char *filename,
			     int flags);

gboolean ochusha_config_cache_file_exist(const OchushaConfig *config,
					 const char *url);
int ochusha_config_cache_open_file(const OchushaConfig *config,
				   const char *url, int flags);
void ochusha_config_cache_unlink_file(const OchushaConfig *config,
				      const char *url);


/*
 * config.xmlϢ
 */
typedef void WritePreferenceElementFunc(FILE *config_xml, gpointer user_data);
typedef void ReadPreferenceElementFunc(GHashTable *pref_attrs,
				       gpointer user_data);

gboolean ochusha_write_config_xml(OchushaConfig *config,
				  WritePreferenceElementFunc *optional,
				  gpointer user_data);
void ochusha_read_config_xml(OchushaConfig *config,
			     ReadPreferenceElementFunc *optional,
			     gpointer user_data);


/*
 * GHashTableͤФؿ
 */
gboolean ochusha_utils_get_attribute_boolean(GHashTable *hash_table,
					     const char *attr_name);
int ochusha_utils_get_attribute_int(GHashTable *hash_table,
				    const char *attr_name);
char *ochusha_utils_get_attribute_string(GHashTable *hash_table,
					 const char *attr_name);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_H_ */
