/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: bbs_thread_view.h,v 1.14 2003/12/02 01:41:13 fuyu Exp $
 */

#ifndef _BBS_THREAD_VIEW_H_
#define _BBS_THREAD_VIEW_H_

#include "ochusha.h"

#include <gtk/gtk.h>

#if ENABLE_REGEXP
# if HAVE_ONIGURUMA
#  if HAVE_ONIG_ONIGPOSIX_H
#    include <onig/onigposix.h>
#  elif HAVE_ONIGPOSIX_H
#    include <onigposix.h>
#  else
#    error "Use of oniguruma without onig/onigposix.h header isn't considered."
#  endif
# else
#  if HAVE_POSIX_REGEX
#    if HAVE_SYS_TYPES_H
#      include <sys/types.h>
#    endif
#    if HAVE_REGEX_H
#      include <regex.h>
#    else
#      warning "I don't know suitable header file of your posix regex library."
#    endif
#  endif
# endif
#endif

#ifdef __cplusplus
extern "C" {
#endif


#define BBS_THREAD_VIEW_TYPE			(bbs_thread_view_get_type())
#define BBS_THREAD_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), BBS_THREAD_VIEW_TYPE, BBSThreadView))
#define BBS_THREAD_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), BBS_THREAD_VIEW_TYPE, BBSThreadViewClass))
#define IS_BBS_THREAD_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), BBS_THREAD_VIEW_TYPE))
#define IS_BBS_THREAD_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), BBS_THREAD_VIEW_TYPE))
#define BBS_THREAD_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), BBS_THREAD_VIEW_TYPE, BBSThreadViewClass))


typedef struct _BBSThreadView BBSThreadView;
typedef struct _BBSThreadViewClass BBSThreadViewClass;

typedef enum {
  BBS_THREAD_VIEW_SEARCH_DIRECTION_BACKWARD = 0,
  BBS_THREAD_VIEW_SEARCH_DIRECTION_FORWARD = 1,
} BBSThreadViewSearchDirection;


typedef enum {
  BBS_THREAD_VIEW_SEARCH_ACTION_FORWARD,
  BBS_THREAD_VIEW_SEARCH_ACTION_BACKWARD,
  BBS_THREAD_VIEW_SEARCH_ACTION_REGEXP_FORWARD,
  BBS_THREAD_VIEW_SEARCH_ACTION_REGEXP_BACKWARD,
  BBS_THREAD_VIEW_SEARCH_ACTION_TERMINATE
} BBSThreadViewSearchAction;


struct _BBSThreadView
{
  GtkTextView text_view;

  GtkTextBuffer *text_buffer;

  GdkCursor *ibeam_cursor;
  GdkCursor *hand_cursor;

  /* Хåե˻Ȥ */
  GtkTextIter iter;
  GSList *tags;

  /* ʥطǻȤ */
  gint last_offset;
  OchushaBBSThread *thread;
  GHashTable *link_table;	/* offset=>linkʥơ֥ */


  /* طǻȤ */
  gint last_match_offset;
  guint idle_search_func;
  GtkTextMark *insert_mark;
  GtkTextMark *selection_bound_mark;


  gchar *search_key;
#if ENABLE_REGEXP
  regex_t regexp;
  regmatch_t *regexp_match;
#endif
  guint alt_link_tag		: 1;
  guint alt_sage_tag		: 1;
  guint last_is_new_line	: 1;

  guint regexp_available	: 1;
  guint search_direction	: 1;
  guint enable_wrap		: 1;
  guint match_case		: 1;
  guint use_regexp		: 1;
};


struct _BBSThreadViewClass
{
  GtkTextViewClass parent_class;

  GtkTextTagTable *tag_table;

  void (*link_mouse_over)(BBSThreadView *bbs_thread_view,
			  GdkEventMotion *event,
			  OchushaBBSThread *thread, const gchar *link);
  void (*link_mouse_out)(BBSThreadView *bbs_thread_view,
			 GdkEventAny *event,
			 OchushaBBSThread *thread, const gchar *link);
  gboolean (*link_mouse_press)(BBSThreadView *bbs_therad_view,
			       GdkEventButton *event,
			       OchushaBBSThread *thread, const gchar *link);
  gboolean (*link_mouse_release)(BBSThreadView *bbs_thread_view,
				 GdkEventButton *event,
				 OchushaBBSThread *thread, const gchar *link);

  void (*view_enter_notify)(BBSThreadView *bbs_thread_view,
			    GdkEventCrossing *event);
  void (*view_leave_notify)(BBSThreadView *bbs_thread_view,
			    GdkEventCrossing *event);

  void (*scroll_to)(BBSThreadView *bbs_thread_view, gint to_where);
  void (*move_cursor)(BBSThreadView *bbs_thread_view, GtkMovementStep step,
		      gint count, gboolean extend_selection);
  void (*interactive_search)(BBSThreadView *bbs_thread_view,
			     BBSThreadViewSearchAction action);
  void (*write_response)(BBSThreadView *bbs_thread_view);
  void (*close_thread)(BBSThreadView *bbs_thread_view);
};


GType bbs_thread_view_get_type(void);

GtkTextTagTable *bbs_thread_view_class_get_default_tag_table(BBSThreadViewClass *klass);

GtkWidget *bbs_thread_view_new(OchushaBBSThread *thread);
void bbs_thread_view_set_thread(BBSThreadView *view, OchushaBBSThread *thread);
OchushaBBSThread *bbs_thread_view_get_thread(BBSThreadView *view);

void bbs_thread_view_clear(BBSThreadView *view);

gint bbs_thread_view_get_current_offset(BBSThreadView *view);
GtkTextMark *bbs_thread_view_create_mark(BBSThreadView *view);
void bbs_thread_view_delete_mark(BBSThreadView *view, GtkTextMark *mark);
void bbs_thread_view_append_text(BBSThreadView *view, const gchar *text,
				 int len);
void bbs_thread_view_append_text_as_link(BBSThreadView *view,
					 const gchar *text, int len,
					 const gchar *link);
void bbs_thread_view_append_text_as_sage(BBSThreadView *view,
					 const gchar *text, int len,
					 const gchar *link);
void bbs_thread_view_append_widget(BBSThreadView *view, GtkWidget *widget);

GtkTextTag *bbs_thread_view_get_tag_by_name(BBSThreadView *view,
					    const gchar *name);

void bbs_thread_view_push_tag_by_name(BBSThreadView *view, const gchar *name);
void bbs_thread_view_push_tag(BBSThreadView *view, GtkTextTag *tag);
GtkTextTag *bbs_thread_view_pop_tag(BBSThreadView *view);
void bbs_thread_view_pop_tags(BBSThreadView *view, GtkTextTag *tag);

void bbs_thread_view_scroll_to_start(BBSThreadView *view);
void bbs_thread_view_scroll_to_end(BBSThreadView *view);
void bbs_thread_view_scroll_to_mark(BBSThreadView *view, GtkTextMark *mark);
gint bbs_thread_view_scroll_to_offset(BBSThreadView *view, gint offset);
GtkTextMark *bbs_thread_view_create_mark_at_offset(BBSThreadView *view,
						   gint offset);
void bbs_thread_view_place_cursor_at_offset(BBSThreadView *view, gint offset);


gboolean bbs_thread_view_find(BBSThreadView *view, const gchar *key,
			      BBSThreadViewSearchDirection direction,
			      gboolean enable_wrap, gboolean match_case,
			      gboolean use_regexp);
gboolean bbs_thread_view_find_next(BBSThreadView *view);
void bbs_thread_view_invalidate_search_result(BBSThreadView *view);



#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _BBS_THREAD_VIEW_H_ */
