/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ts_engine.h,v 1.4 2003/12/29 18:44:17 fuyu Exp $
 */

#ifndef _TS_ENGINE_H_
#define _TS_ENGINE_H_

#include <glib-object.h>
#include <glib.h>

#include <stdarg.h>
#include <stdio.h>


#ifdef __cplusplus
extern "C" {
#endif


#define TS_TYPE_ENGINE			(ts_engine_get_type())
#define TS_ENGINE(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), TS_TYPE_ENGINE, TSEngine))
#define TS_ENGINE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), TS_TYPE_ENGINE, TSEngineClass))
#define TS_IS_ENGINE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), TS_TYPE_ENGINE))
#define TS_IS_ENGINE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), TS_TYPE_ENGINE))
#define TS_ENGINE_GET_CLASS(obj) 	(G_TYPE_INSTANCE_GET_CLASS((obj), TS_TYPE_ENGINE, TSEngineClass))


typedef struct _TSEngine TSEngine;
typedef struct _TSEngineClass TSEngineClass;
typedef struct _TSCellHandle TSCellHandle;

#ifndef _TS_CORE_H_
typedef struct _TSCore TSCore;
#endif


struct _TSEngine
{
  GObject parent_object;

  TSCore *ts_core;

  TSCellHandle *nil;
  TSCellHandle *t;
  TSCellHandle *f;

  gboolean is_busy;
};


struct _TSEngineClass
{
  GObjectClass parent_class;
};


GType ts_engine_get_type(void);
TSEngine *ts_engine_new(gboolean use_internal_init_scm);

void ts_engine_set_gc_verbose(TSEngine *engine, gboolean verbose);
gboolean ts_engine_get_gc_verbose(TSEngine *engine);

void ts_engine_set_input_file(TSEngine *engine, FILE *file);
void ts_engine_set_input_buffer(TSEngine *engine, char *buffer, size_t len);
void ts_engine_set_output_file(TSEngine *engine, FILE *file);
void ts_engine_set_output_buffer(TSEngine *engine, char *buffer, size_t len);

int ts_engine_load_file(TSEngine *engine, FILE *file);
int ts_engine_load_string(TSEngine *engine, char *text);


void ts_engine_define_global(TSEngine *engine, const char *name,
			     const TSCellHandle *value);
void ts_engine_define_global_long(TSEngine *engine, const char *name,
				  long value);
void ts_engine_define_global_double(TSEngine *engine, const char *name,
				    double value);
void ts_engine_define_global_string(TSEngine *engine, const char *name,
				    const char *value);

TSCellHandle *ts_engine_evalf0(TSEngine *engine, const TSCellHandle *symbol,
			       const char *fmt, ...);
TSCellHandle *ts_engine_evalf(TSEngine *engine, const char *name,
			      const char *fmt, ...);
TSCellHandle *ts_engine_vevalf0(TSEngine *engine, const TSCellHandle *symbol,
				const char *fmt, va_list ap);
TSCellHandle *ts_engine_vevalf(TSEngine *engine, const char *name,
			       const char *fmt, va_list ap);


TSCellHandle *ts_engine_get_global_env(TSEngine *engine);
void ts_engine_define(TSEngine *engine, const TSCellHandle *env,
		      const TSCellHandle *symbol, const TSCellHandle *value);
TSCellHandle *ts_engine_eval(TSEngine *engine, const TSCellHandle *symbol,
			     const TSCellHandle *args);


TSCellHandle *ts_engine_mk_cell_cons(TSEngine *engine,
				     const TSCellHandle *a,
				     const TSCellHandle *d, int immutable);
TSCellHandle *ts_engine_mk_cell_long(TSEngine *engine, long value);
TSCellHandle *ts_engine_mk_cell_double(TSEngine *engine, double value);
TSCellHandle *ts_engine_mk_cell_symbol(TSEngine *engine, const char *name);
TSCellHandle *ts_engine_mk_cell_string(TSEngine *engine, const char *str);
TSCellHandle *ts_engine_mk_cell_character(TSEngine *engine, int c);

TSCellHandle *ts_engine_list_reverse(TSEngine *engine,
				     const TSCellHandle *list);
TSCellHandle *ts_engine_list_reverse_in_place(TSEngine *engine,
					      const TSCellHandle *term,
					      const TSCellHandle *list);
TSCellHandle *ts_engine_list_append(TSEngine *engine,
				    const TSCellHandle *a,
				    const TSCellHandle *b);

gboolean ts_cell_handle_is_long(const TSCellHandle *handle);
long ts_cell_handle_get_long_value(const TSCellHandle *handle);
gboolean ts_cell_handle_is_double(const TSCellHandle *handle);
double ts_cell_handle_get_double_value(const TSCellHandle *handle);
gboolean ts_cell_handle_is_string(const TSCellHandle *handle);
const char *ts_cell_handle_get_string(const TSCellHandle *handle);
char * ts_cell_handle_mighty_get_string(const TSCellHandle *handle);
gboolean ts_cell_handle_is_symbol(const TSCellHandle *handle);

gboolean ts_cell_handle_is_pair(const TSCellHandle *handle);
TSCellHandle *ts_cell_handle_get_car(const TSCellHandle *handle);
TSCellHandle *ts_cell_handle_get_cdr(const TSCellHandle *handle);



#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _TS_ENGINE_H_ */
