/**********************************************************************

  ascii.c -  Oniguruma (regular expression library)

  Copyright (C) 2003  K.Kosako (kosako@sofnec.co.jp)

**********************************************************************/
#include "regint.h"

static int
ascii_mbc_to_lower(UChar* p, UChar* lower)
{
  *lower = ENC_ASCII_CODE_TO_LOWER_CASE(*p);
  return 1; /* return byte length of converted char to lower */
}

static int
ascii_mbc_is_case_ambig(UChar* p)
{
  return ENC_IS_ASCII_CODE_CASE_AMBIG(*p);
}

static int
ascii_code_is_ctype(CodePoint code, unsigned int ctype)
{
  if (code < 256)
    return ENC_IS_ASCII_CODE_CTYPE(code, ctype);
  else
    return FALSE;
}

RegCharEncodingType RegEncodingASCII = {
  {
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
  },
  "ASCII",   /* name */
  1,         /* max byte length */
  FALSE,     /* is_fold_match */
  ENC_CTYPE_SUPPORT_LEVEL_SB_ONLY,  /* ctype_support_level */
  TRUE,                             /* is continuous sb mb codepoint */
  enc_single_byte_mbc_to_code,
  enc_single_byte_code_to_mbclen,
  enc_single_byte_code_to_mbc_first,
  enc_single_byte_code_to_mbc,
  ascii_mbc_to_lower,
  ascii_mbc_is_case_ambig,
  ascii_code_is_ctype,
  enc_nothing_get_ctype_code_range,
  enc_single_byte_left_adjust_char_head,
  enc_single_byte_is_allowed_reverse_match,
  enc_nothing_get_all_fold_match_code,
  enc_nothing_get_fold_match_info
};
