/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_utils_2ch.h,v 1.10 2004/01/30 22:55:47 fuyu Exp $
 */

#ifndef _OCHUSHA_UTILS_2CH_H_
#define _OCHUSHA_UTILS_2CH_H_

#include "ochusha.h"
#include "ochusha_async_buffer.h"
#include "ochusha_bbs_table.h"
#include "ochusha_bulletin_board.h"

#include <glib.h>


#ifdef __cplusplus
extern "C" {
#endif

gboolean ochusha_utils_2ch_check_url(const char *url, char **board_url_p,
				     int *bbs_type_p,
				     char **board_id_p,
				     char **thread_id_p,
				     unsigned int *from_p, unsigned int *to_p,
				     gboolean *is_kako_html_p);

typedef gboolean EachCategoryCallback(OchushaBoardCategory *category,
				      gpointer callback_data);
typedef gboolean EachBoardCallback(OchushaBulletinBoard *board,
				   gpointer callback_data);
typedef OchushaBulletinBoard *BoardMovedCallback(OchushaBulletinBoard *old_one,
						 OchushaBulletinBoard *new_one,
						 gpointer callback_data);

OchushaAsyncBuffer *ochusha_utils_2ch_get_bbsmenu(OchushaNetworkBroker *broker);

gboolean ochusha_utils_2ch_analyze_bbsmenu(OchushaBBSTable *table,
					   OchushaAsyncBuffer *buffer,
					   EachCategoryCallback *category_cb,
					   EachBoardCallback *board_cb,
					   BoardMovedCallback *moved_cb,
					   gpointer callback_data);

typedef enum
{
  OCHUSHA_UTILS_2CH_POST_SUCCESS,
  OCHUSHA_UTILS_2CH_POST_NO_COOKIE,
  OCHUSHA_UTILS_2CH_POST_MOCHITSUKE,
  OCHUSHA_UTILS_2CH_POST_FAILURE,
} OchushaUtils2chPostResult;


OchushaUtils2chPostResult ochusha_utils_2ch_try_post(
						OchushaNetworkBroker *broker,
						OchushaBulletinBoard *board,
						const char *message);
void ochusha_utils_2ch_login(OchushaConfig *config,
			     OchushaNetworkBroker *broker,
			     const char *user_id, const char *passwd);
void ochusha_utils_2ch_logout(OchushaConfig *config);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_UTILS_2CH_H_ */
