/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_ui_private.h,v 1.11.2.1 2004/05/15 17:04:56 fuyu Exp $
 */

#ifndef _OCHUSHA_UI_PRIVATE_H_
#define _OCHUSHA_UI_PRIVATE_H_

#ifdef USE_GTK22_API
/* ʡad-hocн */
#undef GTK_DISABLE_DEPRECATED
#include <gtk/gtk.h>
#undef GTK_MINOR_VERSION
#define GTK_MINOR_VERSION 2
#endif

#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

#define DEBUG_GUI		0
#define DEBUG_GUI_MOST		0
#define DEBUG_THREAD		0
#define DEBUG_THREAD_MOST	0
#define DEBUG_WIDGET		0
#define DEBUG_WIDGET_MOST	0

#define DEBUG_TS_ENGINE		0

#define ENABLE_STRICT_CHECK	0
#define DEBUG_GDK_LOCK		0
#define USE_THREAD_FOR_MAIN	0


#if DEBUG_GDK_LOCK
#ifndef _OCHUSHA_MAIN_C_
extern pthread_t volatile last_lock_owner;
extern volatile const char *last_file;
extern volatile int last_line;
extern pthread_t main_thread;
#endif

void ochu_threads_enter(void);
void ochu_threads_leave(void);

#define OCHU_THREADS_ENTER()						\
  do									\
    {									\
      pthread_t prev;							\
      gdk_threads_enter();						\
      prev = last_lock_owner;						\
      last_lock_owner = pthread_self();					\
      if (prev != NULL)							\
	{								\
	  fprintf(stderr,						\
		  "gdk_threads_enter() at %s, line %d: prev=%p self=%p\n", \
		  __FILE__, __LINE__, prev, last_lock_owner);		\
	  fprintf(stderr, "previous gdk_threads_enter() at %s, line %d\n", \
		  last_file, last_line);				\
	}								\
      last_file = __FILE__;						\
      last_line = __LINE__;						\
    } while (0)

#define OCHU_THREADS_LEAVE()						\
  do									\
    {									\
      pthread_t prev = last_lock_owner;					\
      pthread_t self = pthread_self();					\
      if (prev != self)							\
	{								\
	  fprintf(stderr,						\
		  "gdk_threads_leave() at %s, line %d: prev=%p self=%p\n", \
		  __FILE__, __LINE__, prev, self);			\
	  fprintf(stderr, "previous gdk_threads_enter() at %s, line %d\n", \
		  last_file, last_line);				\
	}								\
      last_lock_owner = NULL;						\
      gdk_threads_leave();						\
    } while (0)

#define OCHU_THREADS_ENTER_FUNC		ochu_threads_enter
#define OCHU_THREADS_LEAVE_FUNC		ochu_threads_leave

#define MAIN_THREAD_EVENT_CALLBACK()					\
  do									\
    {									\
      pthread_t self = pthread_self();					\
      if (main_thread != NULL						\
	  && (last_lock_owner != NULL || self != main_thread))		\
	{								\
	  fprintf(stderr,						\
		  "invalid lock condition at %s, line %d: main=%p, prev=%p self=%p\n", \
		  __FILE__, __LINE__, main_thread, last_lock_owner, self); \
	  fprintf(stderr, "previous gdk_threads_enter() at %s, line %d\n", \
		  last_file, last_line);				\
	}								\
      last_lock_owner = self;						\
      last_file = __FILE__;						\
      last_line = __LINE__;						\
    } while (0)

#define ENTER_MAIN_EVENT_LOOP()						\
  do									\
    {									\
      pthread_t self = pthread_self();					\
      if (last_lock_owner != self)					\
	{								\
	  fprintf(stderr,						\
		  "invalid lock_condition at %s, line %d: main=%p, prev=%p self=%p\n", \
		  __FILE__, __LINE__, main_thread, last_lock_owner, self); \
	  fprintf(stderr, "previous gdk_threads_enter() at %s, line %d\n", \
		  last_file, last_line);				\
	}								\
      else								\
	last_lock_owner = NULL;						\
    } while (0)

#define CHECK_THREADS_ENTERED()						\
  do									\
    {									\
      if (last_lock_owner == NULL)					\
	{								\
	  fprintf(stderr,						\
		  "lock owner unknown: at %s, line %d: main=%p, self=%p\n", \
		  __FILE__, __LINE__, main_thread, pthread_self());	\
	  fprintf(stderr, "previous gdk_threads_enter() at %s, line %d\n", \
		  last_file, last_line);				\
	}								\
    } while (0)

#else

#define OCHU_THREADS_ENTER()		gdk_threads_enter()
#define OCHU_THREADS_LEAVE()		gdk_threads_leave()
#define OCHU_THREADS_ENTER_FUNC		gdk_threads_enter
#define OCHU_THREADS_LEAVE_FUNC		gdk_threads_leave
#define CHECK_THREADS_ENTERED()
#define MAIN_THREAD_EVENT_CALLBACK()
#define ENTER_MAIN_EVENT_LOOP()

#endif	/* DEBUG_GDK_LOCK */

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_UI_PRIVATE_H_ */
