/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.UserList;
import twitter4j.UserListJSONImpl;
import twitter4j.conf.Configuration;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.json.JSONObjectType;

abstract class AbstractStreamImplementation {
    protected static final Logger logger = Logger.getLogger(StatusStreamImpl.class);
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private HttpResponse response;
    protected final Dispatcher dispatcher;
    private final Configuration CONF;

    AbstractStreamImplementation(Dispatcher dispatcher, InputStream stream, Configuration conf) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        this.dispatcher = dispatcher;
        this.CONF = conf;
    }

    AbstractStreamImplementation(Dispatcher dispatcher, HttpResponse response, Configuration conf) throws IOException {
        this(dispatcher, response.asStream(), conf);
        this.response = response;
    }

    protected String parseLine(String line) {
        return line;
    }

    abstract void next(StreamListener[] var1) throws TwitterException;

    protected void handleNextElement() throws TwitterException {
        block6: {
            if (!this.streamAlive) {
                throw new IllegalStateException("Stream already closed.");
            }
            try {
                String line = this.br.readLine();
                if (null == line) {
                    throw new IOException("the end of the stream has been reached");
                }
                this.dispatcher.invokeLater(new StreamEvent(line){

                    public void run() {
                        this.line = AbstractStreamImplementation.this.parseLine(this.line);
                        if (this.line.length() > 0) {
                            try {
                                DataObjectFactoryUtil.clearThreadLocalMap();
                                JSONObject json = new JSONObject(this.line);
                                JSONObjectType jsonObjectType = JSONObjectType.determine(json);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Received:", AbstractStreamImplementation.this.CONF.isPrettyDebugEnabled() ? json.toString(1) : json.toString());
                                }
                                if (JSONObjectType.SENDER == jsonObjectType) {
                                    AbstractStreamImplementation.this.onSender(json);
                                } else if (JSONObjectType.STATUS == jsonObjectType) {
                                    AbstractStreamImplementation.this.onStatus(json);
                                } else if (JSONObjectType.DIRECT_MESSAGE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onDirectMessage(json);
                                } else if (JSONObjectType.DELETE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onDelete(json);
                                } else if (JSONObjectType.LIMIT == jsonObjectType) {
                                    AbstractStreamImplementation.this.onLimit(json);
                                } else if (JSONObjectType.SCRUB_GEO == jsonObjectType) {
                                    AbstractStreamImplementation.this.onScrubGeo(json);
                                } else if (JSONObjectType.FRIENDS == jsonObjectType) {
                                    AbstractStreamImplementation.this.onFriends(json);
                                } else if (JSONObjectType.FAVORITE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onFavorite(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.UNFAVORITE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUnfavorite(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.RETWEET == jsonObjectType) {
                                    AbstractStreamImplementation.this.onRetweet(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.FOLLOW == jsonObjectType) {
                                    AbstractStreamImplementation.this.onFollow(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.UNFOLLOW == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUnfollow(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.USER_LIST_MEMBER_ADDED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListMemberAddition(json.getJSONObject("target"), json.getJSONObject("source"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.USER_LIST_MEMBER_DELETED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListMemberDeletion(json.getJSONObject("target"), json.getJSONObject("source"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.USER_LIST_SUBSCRIBED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListSubscription(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.USER_LIST_UNSUBSCRIBED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListUnsubscription(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.USER_LIST_CREATED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListCreation(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.USER_LIST_UPDATED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListUpdated(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.USER_LIST_DESTROYED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListDestroyed(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.USER_UPDATE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserUpdate(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.BLOCK == jsonObjectType) {
                                    AbstractStreamImplementation.this.onBlock(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.UNBLOCK == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUnblock(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else {
                                    logger.warn("Received unknown event:", AbstractStreamImplementation.this.CONF.isPrettyDebugEnabled() ? json.toString(1) : json.toString());
                                }
                            }
                            catch (Exception ex) {
                                AbstractStreamImplementation.this.onException(ex);
                            }
                        }
                    }
                });
            }
            catch (IOException ioe) {
                try {
                    this.is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                boolean isUnexpectedException = this.streamAlive;
                this.streamAlive = false;
                if (!isUnexpectedException) break block6;
                throw new TwitterException("Stream closed.", ioe);
            }
        }
    }

    protected void onSender(JSONObject json) throws TwitterException {
        logger.warn("Unhandled event: onSender");
    }

    protected void onStatus(JSONObject json) throws TwitterException {
        logger.warn("Unhandled event: onStatus");
    }

    protected void onDirectMessage(JSONObject json) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onDirectMessage");
    }

    protected void onDelete(JSONObject json) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onDelete");
    }

    protected void onLimit(JSONObject json) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onLimit");
    }

    protected void onScrubGeo(JSONObject json) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onScrubGeo");
    }

    protected void onFriends(JSONObject json) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onFriends");
    }

    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        logger.warn("Unhandled event: onFavorite");
    }

    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        logger.warn("Unhandled event: onUnfavorite");
    }

    protected void onRetweet(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        logger.warn("Unhandled event: onRetweet");
    }

    protected void onFollow(JSONObject source, JSONObject target) throws TwitterException {
        logger.warn("Unhandled event: onFollow");
    }

    protected void onUnfollow(JSONObject source, JSONObject target) throws TwitterException {
        logger.warn("Unhandled event: onUnfollow");
    }

    protected void onUserListMemberAddition(JSONObject addedMember, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListMemberAddition");
    }

    protected void onUserListMemberDeletion(JSONObject deletedMember, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListMemberDeletion");
    }

    protected void onUserListSubscription(JSONObject source, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListSubscription");
    }

    protected void onUserListUnsubscription(JSONObject source, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListUnsubscription");
    }

    protected void onUserListCreation(JSONObject source, JSONObject userList) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListCreation");
    }

    protected void onUserListUpdated(JSONObject source, JSONObject userList) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListUpdated");
    }

    protected void onUserListDestroyed(JSONObject source, JSONObject userList) throws TwitterException {
        logger.warn("Unhandled event: onUserListDestroyed");
    }

    protected void onUserUpdate(JSONObject source, JSONObject target) throws TwitterException {
        logger.warn("Unhandled event: onUserUpdate");
    }

    protected void onBlock(JSONObject source, JSONObject target) throws TwitterException {
        logger.warn("Unhandled event: onBlock");
    }

    protected void onUnblock(JSONObject source, JSONObject target) throws TwitterException {
        logger.warn("Unhandled event: onUnblock");
    }

    protected void onException(Exception e) {
        logger.warn("Unhandled event: ", e.getMessage());
    }

    public void close() throws IOException {
        this.streamAlive = false;
        this.is.close();
        this.br.close();
        if (null != this.response) {
            this.response.disconnect();
        }
    }

    protected Status asStatus(JSONObject json) throws TwitterException {
        StatusJSONImpl status = new StatusJSONImpl(json);
        DataObjectFactoryUtil.registerJSONObject(status, json);
        return status;
    }

    protected DirectMessage asDirectMessage(JSONObject json) throws TwitterException {
        DirectMessageJSONImpl directMessage;
        try {
            directMessage = new DirectMessageJSONImpl(json.getJSONObject("direct_message"));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
        DataObjectFactoryUtil.registerJSONObject(directMessage, json);
        return directMessage;
    }

    protected int[] asFriendList(JSONObject json) throws TwitterException {
        try {
            JSONArray friends = json.getJSONArray("friends");
            int[] friendIds = new int[friends.length()];
            for (int i = 0; i < friendIds.length; ++i) {
                friendIds[i] = friends.getInt(i);
            }
            return friendIds;
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    protected User asUser(JSONObject json) throws TwitterException {
        UserJSONImpl user = new UserJSONImpl(json);
        DataObjectFactoryUtil.registerJSONObject(user, json);
        return user;
    }

    protected UserList asUserList(JSONObject json) throws TwitterException {
        UserListJSONImpl userList = new UserListJSONImpl(json);
        DataObjectFactoryUtil.registerJSONObject(userList, json);
        return userList;
    }

    abstract class StreamEvent
    implements Runnable {
        String line;

        StreamEvent(String line) {
            this.line = line;
        }
    }
}

