package osc11ot.android.twittersample;

import java.util.ArrayList;
import java.util.List;

import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.http.AccessToken;
import twitter4j.http.RequestToken;
import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;

public class MainActivity extends Activity {
	private static final String CONSUMER_KEY = "yKpNTNfzgBArazXD4YYqQ";
	private static final String CONSUMER_SERCRET = "UOq30kqYI8jWhMO06Jzufbo0B8s9S6hBUXK1GvT2Ayo";
	private static final String CALLBACK_URL = "osc11ot://oauthcallback";
	private static final int REQUEST_CODE = 1;
	
	private static final String PREF_TOKEN = "token";
	private static final String PREF_SECRET = "tokenSecret";

	private Twitter twitter;
	private RequestToken requestToken;
	private List<String> tweetList;
	private ArrayAdapter<String> tweetListAdapter;

	private Button loginButton;
	private Button updateButton;
	private Button reloadButton;

	@Override
	protected void onNewIntent(Intent intent) {
		Log.d(Const.TAG, "new intent");
		super.onNewIntent(intent);
		AccessToken token;
		Uri uri = intent.getData();
		Log.d("osc11ot", String.format("URI : %s", uri.toString()));
		if (uri != null && uri.toString().startsWith(CALLBACK_URL)) {
			String verifier = uri.getQueryParameter("oauth_verifier");
			try {
				token = twitter.getOAuthAccessToken(requestToken, verifier);
				saveAccessToken(token);
				switchButtonEnable();
				reloadTweet();

				Toast.makeText(this, "OAuthɐ܂", Toast.LENGTH_SHORT).show();
				Log.i(Const.TAG, "success oauth");
			} catch (TwitterException e) {
				e.printStackTrace();
			}
		}
	}

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		
		tweetList = new ArrayList<String>();
		ListView listView = (ListView) findViewById(R.id.tweetListView);
		tweetListAdapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_list_item_1, tweetList);
		listView.setAdapter(tweetListAdapter);

		loginButton = (Button) findViewById(R.id.loginButton);
		loginButton.setOnClickListener(new LoginButtonOnClickListener());

		updateButton = (Button) findViewById(R.id.openTweetButton);
		updateButton.setOnClickListener(new OpenTweetButtonOnClickListener());
		updateButton.setEnabled(false);

		reloadButton = (Button)findViewById(R.id.ReloadButton);
		reloadButton.setOnClickListener(new ReloadButtonOnClickListener());
		reloadButton.setEnabled(false);
		
		AccessToken token = loadAccessToken();
		if (token != null) {
			twitter =  new TwitterFactory().getInstance();
			twitter.setOAuthConsumer(CONSUMER_KEY, CONSUMER_SERCRET);
			twitter.setOAuthAccessToken(token);
			switchButtonEnable();
			reloadTweet();
		}
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		switch (requestCode) {
		case REQUEST_CODE:
			if (resultCode == RESULT_OK) {
				CharSequence tweet = data.getCharSequenceExtra(Const.TWEET);
				if (tweet != null) updateTweet(tweet.toString());
			}
		}
	};

	private void switchButtonEnable() {
		loginButton.setVisibility(View.INVISIBLE);
		updateButton.setEnabled(true);
		reloadButton.setEnabled(true);
	}
	
	private void updateTweet(String tweet) {
		try {
			twitter.updateStatus(tweet);
		} catch (TwitterException e) {
			Log.w(Const.TAG, "update error", e);
			Toast.makeText(MainActivity.this, R.string.error_updateStatus, Toast.LENGTH_LONG);
		}
	}

	private void reloadTweet() {
		try {
			List<Status> list = twitter.getFriendsTimeline();
			tweetList.clear();
			for (Status status : list) {
				tweetList.add(String.format("%s: %s  %tF %tT", status.getUser()
						.getName(), status.getText(), status.getCreatedAt(),
						status.getCreatedAt()));
			}
			tweetListAdapter.notifyDataSetChanged();
		} catch (TwitterException e) {
			Log.w(Const.TAG, "error", e);
			Toast.makeText(MainActivity.this, R.string.error_getTimeLine,
					Toast.LENGTH_LONG).show();
		}
	}
	
	private void saveAccessToken(AccessToken token) {
		SharedPreferences pref = getSharedPreferences(PREF_TOKEN,
				MODE_PRIVATE);
		SharedPreferences.Editor editor = pref.edit();
		editor.putString(PREF_TOKEN, token.getToken());
		editor.putString(PREF_TOKEN, token.getTokenSecret());
		editor.commit();
	}
	
	private AccessToken loadAccessToken() {
		AccessToken result = null;
		SharedPreferences pref = getSharedPreferences(PREF_TOKEN,
				MODE_PRIVATE);
		String token = pref.getString(PREF_TOKEN, null);
		String secret = pref.getString(PREF_SECRET, null);
		
		if (token != null && secret != null) {
			result = new AccessToken(token, secret);
		}
		
		return result;
	}

	class LoginButtonOnClickListener implements OnClickListener {
		public void onClick(View view) {
			try {
				twitter = new TwitterFactory().getInstance();
				twitter.setOAuthConsumer(CONSUMER_KEY, CONSUMER_SERCRET);
				requestToken = twitter.getOAuthRequestToken(CALLBACK_URL);
				String url = requestToken.getAuthorizationURL();
				startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(url)));
			} catch (Exception e) {
				Log.e(Const.TAG, "error", e);
			}
		}
	}

	class OpenTweetButtonOnClickListener implements OnClickListener {
		public void onClick(View view) {
			Intent intent = new Intent(MainActivity.this, InputActivity.class);
			startActivityForResult(intent, REQUEST_CODE);
		}
	}

	class ReloadButtonOnClickListener implements OnClickListener {
		public void onClick(View view) {
			Log.d(Const.TAG, "reload clicked");
			reloadTweet();
		}
	}
}