unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, MSGSnatchers, OleDnD, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    FileDropSource1: TFileDropSource;
    FileDropSource2: TFileDropSource;
    GroupBox1: TGroupBox;
    ListBox1: TListBox;
    GroupBox2: TGroupBox;
    ListView1: TListView;
    Label1: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    procedure FileDropSource1RecognizeStart(aSender: TObject;
      aButton: TMouseButton; aScreenMousePos: TPoint;
      var aMode: TRecognizeStartingMode);
    procedure FileDropSource1Recognized(aSender: TObject;
      aButton: TMouseButton);
    procedure FileDropSource2RecognizeStart(aSender: TObject;
      aButton: TMouseButton; aScreenMousePos: TPoint;
      var aMode: TRecognizeStartingMode);
    procedure FileDropSource2Recognized(aSender: TObject;
      aButton: TMouseButton);
    procedure RadioButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FileDropSource1RecognizeStart(aSender: TObject;
  aButton: TMouseButton; aScreenMousePos: TPoint;
  var aMode: TRecognizeStartingMode);
begin
  if ListBox1.SelCount = 0 then aMode := rmCancel;
end;

procedure TForm1.FileDropSource1Recognized(aSender: TObject;
  aButton: TMouseButton);
var
  i: Integer;
begin
  FileDropSource1.Files.Clear;
  with ListBox1 do begin
    for i := 0 to Items.Count - 1 do
      if Selected[i] then FileDropSource1.Files.Add(Items[i]);
  end;
end;

procedure TForm1.FileDropSource2RecognizeStart(aSender: TObject;
  aButton: TMouseButton; aScreenMousePos: TPoint;
  var aMode: TRecognizeStartingMode);
begin
  if ListView1.SelCount = 0 then aMode := rmCancel;
end;

procedure TForm1.FileDropSource2Recognized(aSender: TObject;
  aButton: TMouseButton);
var
  i: Integer;
begin
  FileDropSource2.Files.Clear;
  with ListView1 do begin
    for i := 0 to Items.Count - 1 do
      if Items[i].Selected then FileDropSource2.Files.Add(Items[i].Caption);
  end;
end;

procedure TForm1.RadioButtonClick(Sender: TObject);
var
  style: TViewStyle;
begin
  case (Sender as TRadioButton).Tag of
    0: style := vsIcon;
    1: style := vsSmallIcon;
    2: style := vsList;
    3: style := vsReport;
  else
    style := vsReport;
  end;
  ListView1.ViewStyle := style;
end;

end.
