unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleDnD, StdCtrls, ActiveX, ExtCtrls, ComCtrls, MSGSnatchers;

type
  TForm1 = class(TForm)
    OleDropTarget1: TOleDropTarget;
    FileDropSource1: TFileDropSource;
    GroupBox1: TGroupBox;
    Image1: TImage;
    GroupBox2: TGroupBox;
    ListBoxFormats: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    GroupBox3: TGroupBox;
    PageControl1: TPageControl;
    TabSheetUnsupported: TTabSheet;
    TabSheetCFHDrop: TTabSheet;
    TabSheetCFText: TTabSheet;
    TabSheetCFBitmap: TTabSheet;
    Label7: TLabel;
    MemoCFText: TMemo;
    ScrollBox1: TScrollBox;
    ImageCFBitmap: TImage;
    MemoCFHDrop: TMemo;
    FileDropTarget1: TFileDropTarget;
    GroupBox4: TGroupBox;
    Label8: TLabel;
    MemoFileDrag: TMemo;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    TabSheetCFRichText: TTabSheet;
    RichEditCFRichText: TRichEdit;
    procedure DFItem_CF_HDROP_Drop(aSender: TObject;
      var aContext: TDragContext);
    procedure DFItem_CF_TEXT_Drop(aSender: TObject;
      var aContext: TDragContext);
    procedure DFItem_CF_BITMAP_Drop(aSender: TObject;
      var aContext: TDragContext);
    procedure DFItem_RichTextFormat_Drop(aSender: TObject;
      var aContext: TDragContext);
    procedure FileDropTarget1DragEnter(aSender: TObject;
      var aContext: TDragContext);
    procedure FileDropTarget1DragOver(aSender: TObject;
      var aContext: TDragContext);
    procedure FileDropTarget1DragLeave(aSender: TObject;
      var aResult: HRESULT);
    procedure FileDropTarget1Drop(aSender: TObject;
      var aContext: TDragContext);
    procedure OleDropTarget1DragEnter(aSender: TObject;
      var aContext: TDragContext);
  private
    { Private 錾 }
    procedure AddFormatEtc(const aFormat: TFormatEtc);
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

uses
  OleDnDUtils, DataObjects;

{$R *.dfm}

procedure TForm1.AddFormatEtc(const aFormat: TFormatEtc);
begin
  ListBoxFormats.Items.Add(GetCFName(aFormat.cfFormat));
end;

procedure TForm1.OleDropTarget1DragEnter(aSender: TObject;
  var aContext: TDragContext);
var
  reader: TDataObjectReader;
begin
  ListBoxFormats.Clear;
  reader := TDataObjectReader.Create(aContext.DataObject);
  try
    reader.GetFormats(AddFormatEtc);
  finally
    reader.Free;
  end;
end;

procedure TForm1.DFItem_CF_HDROP_Drop(aSender: TObject;
  var aContext: TDragContext);
begin
  MemoCFHDrop.Clear;
  GetFileList(aContext.DataObject, MemoCFHDrop.Lines);
  PageControl1.ActivePage := TabSheetCFHDrop;
end;

procedure TForm1.DFItem_CF_TEXT_Drop(aSender: TObject;
  var aContext: TDragContext);
begin
  MemoCFText.Text := GetText(aContext.DataObject);
  PageControl1.ActivePage := TabSheetCFText;
end;

procedure TForm1.DFItem_CF_BITMAP_Drop(aSender: TObject;
  var aContext: TDragContext);
begin
  GetBitmap(aContext.DataObject, ImageCFBitmap.Picture.Bitmap);
  ImageCFBitmap.Refresh;
  PageControl1.ActivePage := TabSheetCFBitmap;
end;

procedure TForm1.DFItem_RichTextFormat_Drop(aSender: TObject;
  var aContext: TDragContext);
begin
  GetRichText(aContext.DataObject, RichEditCFRichText.Lines);
  PageControl1.ActivePage := TabSheetCFRichText;
end;

procedure TForm1.FileDropTarget1DragEnter(aSender: TObject;
  var aContext: TDragContext);
begin
  MemoFileDrag.Clear;
  MemoFileDrag.Lines.Add('DragEnter');
end;

procedure TForm1.FileDropTarget1DragOver(aSender: TObject;
  var aContext: TDragContext);
begin
  MemoFileDrag.Lines.Add('DragOver');
end;

procedure TForm1.FileDropTarget1DragLeave(aSender: TObject;
  var aResult: HRESULT);
begin
  MemoFileDrag.Lines.Add('DragLeave');
end;

procedure TForm1.FileDropTarget1Drop(aSender: TObject;
  var aContext: TDragContext);
begin
  MemoFileDrag.Lines.Add('Drop');
  MemoFileDrag.Lines.Add(FileDropTarget1.DroppedFiles.Text);
end;


end.

