unit OleDnDEditors;

// $Id: OleDnDEditors.pas,v 1.5 2002/02/25 17:56:56 takao Exp $

{$ObjExportAll On}

interface

uses
  Classes
{$IFDEF Ver140}
  , DesignEditors, DesignIntf
{$ELSE}
  , DsgnIntf
{$ENDIF}
  , OleDnD;

type
  { TClipboardFormatNamesProperty }
  TClipboardFormatNamesProperty = class(TStringProperty)
  public
	  function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(aProc: TGetStrProc); override;
  end;

  { TDFItemEventProperty }
  TDFItemEventProperty = class(TMethodProperty)
  public
  	function GetFormMethodName: string; override;
  end;

  { TFormComponentProperty }
  TFormComponentProperty = class(TComponentProperty)
    procedure GetValues(aProc: TGetStrProc); override;
  end;

function GetPackedString(aString: string): string;


implementation

uses
  SysUtils, TypInfo, Controls, Dialogs, OleDnDUtils;

{ GetPackedString function }

function GetPackedString(aString: string): string;
var
  i, j, n: Integer;
begin
	n := Length(aString);
	j := 1;
	for i := 1 to n do begin
		if aString[i] <> ' ' then begin
			aString[j] := aString[i];
			Inc(j);
    end;
  end;
  SetLength(aString, j - 1);

  Result := aString;
end;


{ TClipboardFormatNamesProperty }

function TClipboardFormatNamesProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Include(Result, paValueList);
  Include(Result, paSortList);
end;

procedure TClipboardFormatNamesProperty.GetValues(aProc: TGetStrProc);
begin
  inherited;
	GetCFNames(aProc);
end;


{ TDFItemEventProperty }

function TDFItemEventProperty.GetFormMethodName: string;
var
  item: TDFItem;
  str: string;
begin
	item := GetComponent(0) as TDFItem;
	if item = Nil then
		raise Exception.Create('R|[lg TDFItem ł͂܂.');

	if Length(item.FormatName) = 0 then
		raise Exception.Create('FormatName vpeBݒ肵ĉ.');

	str := GetPackedString(item.FormatName);
  Result := 'DFItem_' + str + '_' + GetTrimmedEventName;
end;


{ TFormComponentProperty }

procedure TFormComponentProperty.GetValues(aProc: TGetStrProc);
begin
  inherited GetValues(aProc);

  if GetPropInfo.PropType^.Kind = tkClass then begin
    if Designer.GetRoot.InheritsFrom(GetTypeData(GetPropType).ClassType) then
      aProc(Designer.GetRoot.Name);
  end;
end;

end.
