unit OleDnDRegister;

// $Id: OleDnDRegister.pas,v 1.6 2002/03/19 15:07:39 takao Exp $

{$ObjExportAll On}

interface

procedure Register;


implementation

uses
  Classes, Controls
{$IFDEF VER140}
  , DesignIntf
{$ELSE}
  , DsgnIntf
{$ENDIF}
  , MSGSnatchers, OleDnD, OleDnDEditors;

{ Register procedure }

procedure Register;
begin
  RegisterComponents(
    'TarCtrls'
    , [
      TMessageSnatcher, TWinMessageSnatcher
      , TDragGestureRecognizer
      , TOleDropSource, TFileDropSource
      , TOleDropTarget, TFileDropTarget
    ]
  );

  // for TDFItem
  RegisterPropertyEditor(
    TypeInfo(string), TDFItem, 'FormatName', TClipboardFormatNamesProperty
  );
  RegisterPropertyEditor(
    TypeInfo(TOleDragEvent), TDFItem, 'OnDragEnter', TDFItemEventProperty
  );
  RegisterPropertyEditor(
    TypeInfo(TOleDragEvent), TDFItem, 'OnDragOver', TDFItemEventProperty
  );
  RegisterPropertyEditor(
    TypeInfo(TOleDragEvent), TDFItem, 'OnDrop', TDFItemEventProperty
  );

  // for TCustomMessageSnatcher.Control
  RegisterPropertyEditor(
    TypeInfo(TControl), TCustomMessageSnatcher, 'Control'
    , TFormComponentProperty
  );

  // for TCustomWinMessageSnatcher.WinControl
  RegisterPropertyEditor(
    TypeInfo(TWinControl), TCustomWinMessageSnatcher, 'WinControl'
    , TFormComponentProperty
  );
end;

{$IFDEF VER140}
initialization
  GroupDescendentsWith(TMessageSnatcher, Controls.TControl);
  GroupDescendentsWith(TDragGestureRecognizer, Controls.TControl);
  GroupDescendentsWith(TOleDropSource, Controls.TControl);
  GroupDescendentsWith(TFileDropSource, Controls.TControl);
  GroupDescendentsWith(TOleDropTarget, Controls.TControl);
{$ENDIF}

end.
