/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.MatchResult;
import onig4j.OnigRegion;

class MatchResultImpl
implements MatchResult {
    protected final OnigRegion region;
    protected CharSequence input;
    protected int offset;
    protected boolean hasTransparentBounds;

    MatchResultImpl(OnigRegion region, CharSequence input) {
        this.region = region;
        this.input = input;
    }

    MatchResultImpl(OnigRegion region, CharSequence input, int offset) {
        this.region = region;
        this.input = input;
        this.offset = offset;
    }

    private void validateGroup(int group) {
        int cnt = this.region.count();
        if (cnt <= 0) {
            throw new IllegalStateException("No match available");
        }
        if (group < 0 || group >= cnt) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
    }

    public int start() {
        return this.start(0);
    }

    public int start(int group) {
        this.validateGroup(group);
        int begin = this.region.begin(group);
        if (!this.hasTransparentBounds && begin != -1) {
            begin += this.offset;
        }
        return begin;
    }

    public int end() {
        return this.end(0);
    }

    public int end(int group) {
        this.validateGroup(group);
        int end = this.region.end(group);
        if (!this.hasTransparentBounds && end != -1) {
            end += this.offset;
        }
        return end;
    }

    public String group() {
        return this.group(0);
    }

    public String group(int group) {
        return ((Object)this.input.subSequence(this.start(group), this.end(group))).toString();
    }

    public int groupCount() {
        return this.region.count() > 0 ? this.region.count() - 1 : 0;
    }
}

