/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.MatchResultImpl;
import java.util.regex.Pattern;
import java.util.regex.Patterns;
import onig4j.OnigOptionType;
import onig4j.OnigRegex;
import onig4j.OnigRegion;

public class Matcher
extends MatchResultImpl {
    private Pattern pattern;
    private int start;
    private int range;
    private boolean hasAnchoringBounds;
    private CharSequence regionInput;

    Matcher(Pattern pattern, CharSequence input) {
        super(new OnigRegion(), input);
        this.pattern = pattern;
        this.range = input.length();
        this.hasAnchoringBounds = true;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public MatchResult toMatchResult() {
        return new MatchResultImpl(this.region.clone(), this.input, this.hasAnchoringBounds ? this.offset : 0);
    }

    public Matcher usePattern(Pattern newPattern) {
        if (newPattern == null) {
            throw new IllegalArgumentException("newPattern is null");
        }
        this.pattern = newPattern;
        this.region.resizeClear(0);
        return this;
    }

    public Matcher reset() {
        this.offset = 0;
        this.start = 0;
        this.range = this.input.length();
        this.region.resizeClear(0);
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.input = input;
        return this.reset();
    }

    private int match() {
        int ret = this.regionInput == null ? this.pattern.regex.match(this.input, this.range, 0, this.region) : (this.hasAnchoringBounds ? this.pattern.regex.match(this.regionInput, 0, this.region) : this.pattern.regex.match(this.regionInput, 0, this.region, new OnigOptionType[]{OnigOptionType.ONIG_OPTION_NOTBOL, OnigOptionType.ONIG_OPTION_NOTEOL}));
        this.start = ret >= 0 ? ret : 0;
        return ret;
    }

    public boolean matches() {
        if (this.match() == this.range - this.offset) {
            return true;
        }
        this.region.resizeClear(0);
        return false;
    }

    public boolean find() {
        int ret;
        if (this.regionInput == null) {
            ret = this.pattern.regex.search(this.input, this.start, this.region);
        } else if (this.hasTransparentBounds) {
            int st = this.start + this.offset;
            ret = this.pattern.regex.search(this.input, st, this.region);
            if (ret < st || this.region.end(0) > this.range) {
                ret = -1;
            }
        } else {
            ret = this.hasAnchoringBounds ? this.pattern.regex.search(this.regionInput, this.start, this.region) : this.pattern.regex.search(this.regionInput, this.start, this.region, new OnigOptionType[]{OnigOptionType.ONIG_OPTION_NOTBOL, OnigOptionType.ONIG_OPTION_NOTEOL});
        }
        if (ret >= 0) {
            this.start = this.region.end(0);
            return true;
        }
        return false;
    }

    public boolean find(int start) {
        if (start < 0 || start > this.input.length()) {
            throw new IndexOutOfBoundsException("the start parameter is out of range");
        }
        this.reset();
        this.start = start;
        return this.find();
    }

    public boolean lookingAt() {
        return this.match() >= 0;
    }

    public static String quoteReplacement(String s) {
        StringBuilder quoted = new StringBuilder(s.length());
        for (char ch : s.toCharArray()) {
            if (ch == '\\' || ch == '$') {
                quoted.append('\\');
            }
            quoted.append(ch);
        }
        return quoted.toString();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        sb.append(this.replace(replacement, 1, false));
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        int end = this.input.length();
        if (this.start < end) {
            sb.append(this.input.subSequence(this.start, end));
        }
        return sb;
    }

    private String replace(String replacement, int limit, boolean isAppendTail) {
        int ret;
        Object replace = this.parseReplacement(replacement);
        StringBuilder replaced = new StringBuilder();
        OnigRegex regex = this.pattern.regex;
        int end = this.input.length();
        int off = 0;
        while ((ret = regex.search(this.input, end, this.start + off, this.range, this.region)) >= 0) {
            replaced.append(((Object)this.input.subSequence(this.start, ret)).toString());
            this.start = this.region.end(0);
            replaced.append(replace.toString());
            if (--limit != 0 && (ret != this.start || this.start + (off = 1) < end)) continue;
        }
        if (isAppendTail && this.start < end) {
            replaced.append(((Object)this.input.subSequence(this.start, end)).toString());
        }
        return replaced.toString();
    }

    private static String deleteEscapeChars(String str) {
        int pos = str.indexOf(92);
        if (pos < 0) {
            return str;
        }
        StringBuilder buff = new StringBuilder(str.length());
        int last = str.length() - 1;
        int start = 0;
        do {
            if (pos < last && str.charAt(pos + 1) == '\\') {
                ++pos;
            }
            buff.append(str.substring(start, pos));
        } while ((pos = str.indexOf(92, start = pos + 1)) != -1);
        return buff.append(str.substring(start)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseReplacement(String replacement) {
        OnigRegex regex = new OnigRegex("\\$[0-9]");
        try {
            Object object;
            int e = replacement.length();
            int s = 0;
            int ret = regex.search((CharSequence)replacement, e, s, e);
            if (ret < 0) {
                String string = Matcher.deleteEscapeChars(replacement);
                return string;
            }
            boolean hasPrevReference = false;
            ReplacementObject replace = new ReplacementObject();
            do {
                String literal = Matcher.deleteEscapeChars(replacement.substring(s, ret));
                replace.add(literal);
                s = ret + 2;
                if (Patterns.isNotEscaped(replacement, ret)) {
                    int group = Integer.parseInt(replacement.substring(ret + 1, s));
                    replace.add(new PreviousReferenceObject(group));
                    hasPrevReference = true;
                    continue;
                }
                replace.add(replacement.substring(ret, s));
            } while ((ret = regex.search((CharSequence)replacement, e, s, e)) >= 0);
            if (hasPrevReference) {
                if (s < e && !replace.isEmpty()) {
                    replace.add(replacement.substring(s, e));
                }
                object = replace;
                return object;
            }
            object = Matcher.deleteEscapeChars(replacement);
            return object;
        }
        finally {
            regex.close();
        }
    }

    public String replaceAll(String replacement) {
        this.reset();
        return this.replace(replacement, -1, true);
    }

    public String replaceFirst(String replacement) {
        this.reset();
        return this.replace(replacement, 1, true);
    }

    public Matcher region(int start, int end) {
        int len = this.input.length();
        if (start < 0 || start > end || start > len) {
            throw new IndexOutOfBoundsException("the start parameter is out of range");
        }
        if (end < 0 || end > len) {
            throw new IndexOutOfBoundsException("the end parameter is out of range");
        }
        this.start = 0;
        this.regionInput = start > 0 || end < len ? this.input.subSequence(start, end) : null;
        this.offset = start;
        this.range = end;
        this.region.resizeClear(0);
        return this;
    }

    public int regionStart() {
        return this.offset;
    }

    public int regionEnd() {
        return this.range;
    }

    public boolean hasTransparentBounds() {
        return this.hasTransparentBounds;
    }

    public Matcher useTransparentBounds(boolean b) {
        this.hasTransparentBounds = b;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.hasAnchoringBounds;
    }

    public Matcher useAnchoringBounds(boolean b) {
        if (this.hasAnchoringBounds && !b) {
            this.start += this.offset;
        } else if (!this.hasAnchoringBounds && b) {
            this.start -= this.offset;
        }
        this.hasAnchoringBounds = b;
        return this;
    }

    public String toString() {
        return Matcher.class.getName() + "[pattern=" + this.pattern.pattern() + " region=" + this.offset + "," + this.range + " lastmatch=" + (this.region.count() > 0 ? this.group() : "") + "]";
    }

    @Deprecated
    public boolean hitEnd() {
        return this.hasAnchoringBounds ? this.range == this.region.end(0) : this.input.length() == this.end();
    }

    public boolean requireEnd() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private class ReplacementObject {
        private final List<Object> replace = new ArrayList<Object>();

        private ReplacementObject() {
        }

        public void add(Object e) {
            this.replace.add(e);
        }

        public boolean isEmpty() {
            return this.replace.isEmpty();
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            for (Object e : this.replace) {
                buff.append(e.toString());
            }
            return buff.toString();
        }
    }

    private class PreviousReferenceObject {
        private final int group;

        private PreviousReferenceObject(int group) {
            this.group = group;
        }

        public String toString() {
            return Matcher.this.group(this.group);
        }
    }
}

