/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Patterns;
import onig4j.OnigOptionType;
import onig4j.OnigRegex;
import onig4j.OnigSyntaxType;

public final class Pattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CANON_EQ = 128;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int DOTALL = 32;
    public static final int LITERAL = 16;
    public static final int MULTILINE = 8;
    public static final int UNICODE_CASE = 64;
    public static final int UNIX_LINES = 1;
    final OnigRegex regex;
    private final String pattern;
    private final int flags;

    private Pattern(String pattern, int flags) {
        this.pattern = pattern;
        this.flags = flags;
        if ((flags & 0x10) == 0) {
            pattern = Patterns.unescapeUnicode(pattern);
            if ((flags & 0x80) != 0) {
                try {
                    pattern = Patterns.normalize(pattern);
                }
                catch (UnsupportedOperationException ex) {
                    throw new UnsupportedOperationException("CANON_EQ option requires the Unicode Normalizer", ex);
                }
            }
        } else {
            pattern = Pattern.quote(pattern);
        }
        ArrayList<OnigOptionType> options = null;
        if (flags != 0) {
            options = new ArrayList<OnigOptionType>(6);
            if ((flags & 2) != 0) {
                options.add(OnigOptionType.ONIG_OPTION_IGNORECASE);
            }
            if ((flags & 0x40) != 0) {
                options.add(OnigOptionType.ONIG_OPTION_NEGATE_CASE_FOLD_ASCII_ONLY);
            }
            if ((flags & 8) != 0) {
                options.add(OnigOptionType.ONIG_OPTION_NEGATE_SINGLELINE);
                if ((flags & 1) != 0) {
                    options.add(OnigOptionType.ONIG_OPTION_NEGATE_JAVA_LINES);
                }
            }
            if ((flags & 0x20) != 0) {
                options.add(OnigOptionType.ONIG_OPTION_MULTILINE);
            }
            if ((flags & 4) != 0) {
                options.add(OnigOptionType.ONIG_OPTION_EXTEND);
            }
        }
        this.regex = new OnigRegex(pattern, OnigSyntaxType.ONIG_SYNTAX_JAVA, options);
    }

    public static Pattern compile(String regex) {
        return new Pattern(regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        return new Pattern(regex, flags);
    }

    public int flags() {
        return this.flags;
    }

    public Matcher matcher(CharSequence input) {
        return new Matcher(this, input);
    }

    public static boolean matches(String regex, CharSequence input) {
        return Pattern.compile(regex).matcher(input).matches();
    }

    public String pattern() {
        return this.pattern;
    }

    public static String quote(String s) {
        return "\\Q" + s + "\\E";
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public String[] split(CharSequence input, int limit) {
        List split = this.regex.split(input, limit);
        return split.toArray(new String[split.size()]);
    }

    public String toString() {
        return this.pattern();
    }
}

