/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import onig4j.OnigRegex;

final class Patterns {
    private static final OnigRegex unicode = new OnigRegex("\\\\u\\h{4}");

    Patterns() {
    }

    static String unescapeUnicode(String pattern) {
        int end = pattern.length();
        int pos = unicode.search((CharSequence)pattern, end, 0, end);
        if (pos < 0) {
            return pattern;
        }
        StringBuilder newPattern = new StringBuilder(end);
        int start = 0;
        do {
            newPattern.append(pattern.substring(start, pos));
            start = pos + 6;
            newPattern.append((char)Integer.parseInt(pattern.substring(pos + 2, start), 16));
        } while (start < end && (pos = unicode.search((CharSequence)pattern, end, start, end)) >= 0);
        if (start < end) {
            newPattern.append(pattern.substring(start));
        }
        return newPattern.toString();
    }

    private static int countPrevEscapeChar(CharSequence cs, int i) {
        int cnt = 0;
        while (i > 0 && cs.charAt(--i) == '\\') {
            ++cnt;
        }
        return cnt;
    }

    static boolean isNotEscaped(CharSequence cs, int index) {
        return Patterns.countPrevEscapeChar(cs, index) % 2 == 0;
    }

    static String normalize(String pattern) {
        try {
            Normalizer normalizer = Normalizer.getInstance();
            String nfc = normalizer.normalizeNFC(pattern);
            String nfd = normalizer.normalizeNFD(pattern);
            int len = nfc.length();
            int capacity = len + (nfd.length() - len) * 7;
            StringBuilder newPattern = new StringBuilder(capacity);
            int i = 0;
            for (char c : nfc.toCharArray()) {
                char d;
                if (c == (d = nfd.charAt(i++))) {
                    newPattern.append(c);
                    continue;
                }
                newPattern.append("(?:");
                newPattern.append(c);
                newPattern.append('|');
                newPattern.append(d);
                newPattern.append(nfd.charAt(i++));
                newPattern.append(')');
            }
            return newPattern.toString();
        }
        catch (ClassNotFoundException ex) {
            throw new UnsupportedOperationException("Requires Unicode Normalizer", ex);
        }
    }

    private static final class Normalizer {
        private static Normalizer instance;
        private final Object NFC;
        private final Object NFD;
        private final Method normalize;

        private static Normalizer getInstance() throws ClassNotFoundException {
            String[][] normalizers;
            if (instance != null) {
                return instance;
            }
            for (String[] param : normalizers = new String[][]{{"java.text.Normalizer$Form", "NFC", "NFD", "java.text.Normalizer", "normalize", "java.lang.CharSequence"}, {"com.ibm.icu.text.Normalizer", "NFC", "NFD", "com.ibm.icu.text.Normalizer", "normalize", "java.lang.String"}, {"com.ibm.icu4jni.text.Normalizer", "UNORM_NFC", "UNORM_NFD", "com.ibm.icu4jni.text.Normalizer", "normalize", "java.lang.String"}}) {
                try {
                    Class<?> clazz = Class.forName(param[0]);
                    Field nfc = clazz.getField(param[1]);
                    Field nfd = clazz.getField(param[2]);
                    clazz = Class.forName(param[3]);
                    Method method = clazz.getMethod(param[4], Class.forName(param[5]), nfc.getType());
                    instance = new Normalizer(method, nfc.get(null), nfd.get(null));
                    return instance;
                }
                catch (Exception ex) {
                }
            }
            throw new ClassNotFoundException("Requires 'java.text.Normalizer' or 'com.ibm.icu.text.Normalizer' or 'com.ibm.icu4jni.text.Normalizer'");
        }

        private Normalizer(Method method, Object nfc, Object nfd) {
            this.normalize = method;
            this.NFC = nfc;
            this.NFD = nfd;
        }

        private String normalizeNFC(CharSequence src) {
            return this.normalize(src, this.NFC);
        }

        private String normalizeNFD(CharSequence src) {
            return this.normalize(src, this.NFD);
        }

        private String normalize(CharSequence src, Object form) {
            try {
                return (String)this.normalize.invoke(null, src, form);
            }
            catch (IllegalAccessException ex) {
                throw new UnsupportedOperationException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedOperationException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnsupportedOperationException(ex);
            }
        }
    }
}

