package java.util.regex;

import onig4j.OnigRegion;
import static onig4j.OnigRegion.ONIG_REGION_NOTPOS;

/**
 *
 * @author calico
 */
class MatchResultImpl implements MatchResult {
    
    protected final OnigRegion region;
    protected CharSequence input;
    protected int offset;
    protected boolean hasTransparentBounds;

    MatchResultImpl(OnigRegion region, CharSequence input) {
        this.region = region;
        this.input = input;
    }

    MatchResultImpl(OnigRegion region, CharSequence input, int offset) {
        this.region = region;
        this.input = input;
        this.offset = offset;
    }

    private void validateGroup(int group) {
        final int cnt = region.count();
        if (cnt <= 0) {
            throw new IllegalStateException("No match available");
        }
        if (group < 0 || group >= cnt) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
    }
    
    // START implements
    public int start() {
        return start(0);
    }

    public int start(int group) {
        validateGroup(group);
        
        int begin = region.begin(group);
        if (!hasTransparentBounds && begin != ONIG_REGION_NOTPOS) {
            begin += offset;
        }
        return begin;
    }

    public int end() {
        return end(0);
    }

    public int end(int group) {
        validateGroup(group);
        
        int end = region.end(group);
        if (!hasTransparentBounds && end != ONIG_REGION_NOTPOS) {
            end += offset;
        }
        return end;
    }

    public String group() {
        return group(0);
    }

    public String group(int group) {
        return input.subSequence(start(group), end(group)).toString();
    }

    public int groupCount() {
        return (region.count() > 0 ? region.count() - 1 : 0);
    }
    // END implements
}
