package onig4j.java.util.regex;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class PatternsTest {

    public PatternsTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

//    @Test
//    public void preprocess() {
//        final String regex = "(?iu-d)πφω(?:(?ud:あいう)えお)*";
//        Patterns pp = Patterns.preprocess(regex, 0);
//        final int flags = pp.flags();
////        assertEquals(Pattern.UNIX_LINES, flags & Pattern.UNIX_LINES);
////        // 埋め込みフラグ'(?u)'は鬼車本体を改造して対応したため、flagsの値は変化しない
//        assertEquals(Pattern.UNICODE_CASE, flags & Pattern.UNICODE_CASE);
//    }
    
    @Test
    public void unescapeUnicode() {
        final String regex = "䀹\\u5e73\\u6210\uuuuuuu3042い\\u3046え\\u304a\\ud801\\udc00";
        
        final String pattern = Patterns.unescapeUnicode(regex);
        assertEquals("䀹平成あいうえお\ud801\udc00", pattern);
    }

//    @Test
//    public void embeddedFlag() {
//        String regex = "(?d)World\\.$";
//        final int flags = Pattern.MULTILINE;
//        assertEquals("World\\.$", Patterns.preprocess(regex, flags).pattern());
//
//        regex = "(?d-im)World\\.$";
//        assertEquals("(?-im)World\\.$", Patterns.preprocess(regex, flags).pattern());
//
//        regex = "(?d-u)World\\.$";
//        assertEquals("World\\.$", Patterns.preprocess(regex, flags).pattern());
//
//        regex = "(?m-u)World\\.$";
//        assertEquals("(?m)World\\.$", Patterns.preprocess(regex, flags).pattern());
//
//        regex = "(?mi-s)World\\.$";
//        assertEquals("(?mi-s)World\\.$", Patterns.preprocess(regex, flags).pattern());
//
//        regex = "(?-d)World\\.$";
//        assertEquals("World\\.$", Patterns.preprocess(regex, flags).pattern());
//    }
    
    @Test
    public void normalize() {
        String pattern = "が";
        assertEquals("(?:が|か\u3099)", Patterns.normalize(pattern));

        pattern = "ダヂヅデド";
        assertEquals("(?:ダ|タ\u3099)(?:ヂ|チ\u3099)(?:ヅ|ツ\u3099)(?:デ|テ\u3099)(?:ド|ト\u3099)", Patterns.normalize(pattern));
        
        assertTrue(Pattern.matches(Patterns.normalize(pattern), "タ\u3099ヂツ\u3099デト\u3099"));
    }
}