/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import java.util.Comparator;

import org.onion_lang.onion.lang.kernel.type.*;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/07/12
 */
public class ConstructorSymbolComparator implements Comparator {

  public ConstructorSymbolComparator() {
  }

  public int compare(Object arg0, Object arg1) {
    ConstructorSymbol c1 = (ConstructorSymbol)arg0;
    ConstructorSymbol c2 = (ConstructorSymbol)arg1;
    int result;
    TypeSymbol[] args1 = c1.getArguments();
    TypeSymbol[] args2 = c2.getArguments();
    result = args1.length - args2.length;
    if(result != 0){
      return result;
    }
    for(int i = 0; i < args1.length; i++){
      if(args1[i] != args2[i]){
        return args1[i].getName().compareTo(args2[i].getName());
      }
    }
    return 0;
  }
}
