/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import org.onion_lang.onion.lang.kernel.ConstructorNode;
import org.onion_lang.onion.lang.kernel.MethodNode;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/06/28
 */
public class LocalContext {
  private boolean isStatic;
  private boolean isGlobal;
  private boolean isMethod;
  private LocalFrame frame;
  private MethodSymbol method;
  private ConstructorNode constructor;
  private SymbolGenerator generator;

  public LocalContext() {
    this.frame = new LocalFrame(null);
    this.generator = new SymbolGenerator("symbol#");
  }
  
  public String generateName(){
    return generator.generate();
  }
  
  public boolean isGlobal() {
    return isGlobal;
  }
  
  public void setGlobal(boolean isGlobal) {
    this.isGlobal = isGlobal;
  }
  
  public boolean isStatic() {
    return isStatic;
  }
  
  public void setStatic(boolean isStatic) {
    this.isStatic = isStatic;
  }
  
  public TypeSymbol getReturnType(){
    if(isMethod){
      return method.getReturnType();
    }else{
      return BasicSymbol.VOID;
    }
  }
  
  public MethodSymbol getMethod(){
    return method;
  }
  
  public ConstructorSymbol getConstructor(){
    return constructor;
  }
  
  public void setMethod(MethodSymbol method) {
    this.method = method;
    this.isMethod = true;
  }
  
  public void setConstructor(ConstructorNode constructor){
    this.constructor = constructor;
    this.isMethod = false;
  }
  
  public void openFrame(){
    frame = new LocalFrame(frame);
  }
  
  public void closeFrame(){
    frame = frame.getParent();
  }
  
  public int depth(){
    if(frame == null){
      return -1;
    }else{
      return frame.depth();
    }
  }
  
  public LocalFrame getFrame(){
    return frame;
  }
  
  public void openScope() {
    frame.openScope();
  }
  
  public void closeScope() {
    frame.closeScope();
  }
  
  public ClosureLocalBinding lookup(String name) {
    return frame.lookup(name);
  }
  
  public ClosureLocalBinding lookupOnlyCurrentScope(String name){
    return frame.lookupOnlyCurrentScope(name);
  }
  
  public int addEntry(String name, TypeSymbol type) {
    return frame.addEntry(name, type);
  }
  
  public String addEntry(TypeSymbol type){
    String name = generateName();
    frame.addEntry(name, type);
    return name;
  }
}
