/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.type.TypeRules;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/06/30
 */
public class StandardParameterMatcher implements ParameterMatcher {
  public StandardParameterMatcher() {
  }
  
  public boolean matches(TypeSymbol[] arguments, ExpressionNode[] parameters){
    return matchesSub(arguments, parameters);
  }
  
  private static boolean matchesSub(
    TypeSymbol[] arguments, ExpressionNode[] parameters){
    if(arguments.length != parameters.length) return false;
    TypeSymbol[] parameterTypes = new TypeSymbol[parameters.length];
    for(int i = 0; i < parameters.length; i++){
      parameterTypes[i] = parameters[i].type();
    }
    return matchesSub(arguments, parameterTypes);
  }
  
  private static boolean matchesSub(
    TypeSymbol[] arguments, TypeSymbol[] parameterTypes){
    for(int i = 0; i < arguments.length; i++){
      if(!TypeRules.isSuperType(arguments[i], parameterTypes[i])){
        return false;
      }
    }
    return true;
  }
}
