/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import org.onion_lang.onion.lang.syntax.SynchronizedStatement;

/**
 * @author Kota Mizushima
 * 
 */
public class SynchronizationStack {
  private SynchronizedStatement statement;
  private SynchronizationStack previous;
  
  public SynchronizationStack(SynchronizedStatement statement, SynchronizationStack previous) {
    this.statement	= statement;
    this.previous	 	= previous;
  }

  public SynchronizationStack getPrevious() {
    return previous;
  }
  
  public SynchronizedStatement getStatement(){
    return statement;
  }
  
  public int getID(){ return statement.getID(); }
  public int getExceptionID(){ return statement.getExceptionID(); }
}