/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.utility;

import org.onion_lang.onion.compiler.environment.ClassTable;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.NewNode;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/07/10
 */
public class Boxing {
  private Boxing() {
  }
  
  public static ExpressionNode boxing(ClassTable table, ExpressionNode node){
    BasicSymbol type = (BasicSymbol) node.type();
    ClassSymbol boxedType;
    if(type == BasicSymbol.BOOLEAN){
      boxedType = table.load("java.lang.Boolean");
    }else if(type == BasicSymbol.BYTE){
      boxedType = table.load("java.lang.Byte");
    }else if(type == BasicSymbol.SHORT){
      boxedType = table.load("java.lang.Short");
    }else if(type == BasicSymbol.CHAR){
      boxedType = table.load("java.lang.Character");
    }else if(type == BasicSymbol.INT){
      boxedType = table.load("java.lang.Integer");
    }else if(type == BasicSymbol.LONG){
      boxedType = table.load("java.lang.Long");
    }else if(type == BasicSymbol.FLOAT){
      boxedType = table.load("java.lang.Float");
    }else if(type == BasicSymbol.DOUBLE){
      boxedType = table.load("java.lang.Double");
    }else{
      return null;
    }
    ConstructorSymbol[] cs = boxedType.getConstructors();
    for(int i = 0; i < cs.length; i++){
      TypeSymbol[] args = cs[i].getArguments();
      if(args.length == 1 && args[i] == type){
        return new NewNode(cs[i], new ExpressionNode[]{node});
      }
    }
    return null;
  }
}
