/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.utility;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * @author Kota Mizushima
 * Date: 2005/06/17
 */
public class Messages {
  private static final ResourceBundle ERROR_MESSAGES = 
    ResourceBundle.getBundle("resources.errorMessage");
  private Messages() {
  }

  public static String get(String property){
    return ERROR_MESSAGES.getString(property);
  }
  
  public static String get(String property, Object[] arguments){
    return MessageFormat.format(get(property), arguments);
  }
}
