/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.ArraySymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/06/21
 */
public class ArrayRefNode extends ExpressionNode {
  private ExpressionNode target;
  private ExpressionNode index;

  public ArrayRefNode(ExpressionNode target, ExpressionNode index) {
    this.target = target;
    this.index = index;
  }

  public ExpressionNode getIndex() {
    return index;
  }
  
  public void setIndex(ExpressionNode index) {
    this.index = index;
  }
  
  public ExpressionNode getTarget() {
    return target;
  }
  
  public void setTarget(ExpressionNode target) {
    this.target = target;
  }
  
  public TypeSymbol type(){
    return ((ArraySymbol)target.type()).getBase();
  }
}