/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.compiler.environment.LocalFrame;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class MethodNode implements KernelNode, MethodSymbol {
  private int modifier;  
  private ClassSymbol classType;
  private String name;
  private TypeSymbol[] arguments;
  private BlockNode block;
  private TypeSymbol returnType;
  private boolean closure;
  private LocalFrame frame;

  public MethodNode(
    int modifier, ClassSymbol classType, String name, TypeSymbol[] arguments,
    TypeSymbol returnType, BlockNode block){
    this.modifier = modifier;
    this.classType = classType;
    this.name = name;
    this.arguments = arguments;
    this.returnType = returnType;
    this.block = block;
  }
  
  public int getModifier() {
    return modifier;
  }
  
  public ClassSymbol getClassType() {
    return classType;
  }
  
  public String getName() {
    return name;
  }
  
  public TypeSymbol[] getArguments() {
    return arguments;
  }
  
  public TypeSymbol getReturnType(){
    return returnType;
  }
  
  public BlockNode getBlock() {
    return block;
  }
  
  public void setBlock(BlockNode block){
    this.block = block;
  }
  
  public void setClosure(boolean closure){
    this.closure = closure;
  }
  
  public boolean hasClosure(){
    return closure;
  }
  
  public void setFrame(LocalFrame frame) {
    this.frame = frame;
  }
  
  public LocalFrame getFrame() {
    return frame;
  }
}