/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class UnaryExpressionNode extends ExpressionNode {
  public interface Constants {
  	int PLUS = 0;
  	int MINUS = 1;
  	int NOT = 2;
  	int BIT_NOT = 3;
  }
  
  private int kind;
  private ExpressionNode operand;
  private TypeSymbol type;

  public UnaryExpressionNode(
    int kind, TypeSymbol type, ExpressionNode operand) {
    this.kind = kind;
    this.operand = operand;
    this.type = type;
  }
  
  public int getKind(){
    return kind;
  }
  
  public ExpressionNode getOperand(){
    return operand;
  }
  
  public TypeSymbol type() { return type; }
}