/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel.type;

import org.onion_lang.onion.lang.kernel.ExpressionNode;

/**
 * @author Kota Mizushima
 * Date: 2005/06/22
 */
public class TypeRules {
  
  private TypeRules() {
  }

  public static boolean isSuperType(
    TypeSymbol left, TypeSymbol right){
    if(left.isBasicType()){
      if(right.isBasicType()){
        return isSuperTypeForBasic((BasicSymbol) left, (BasicSymbol) right);
      }
      return false;
    }
    
    if(left.isClassType()){
      if(right.isClassType()){
        return isSuperTypeForClass((ClassSymbol) left, (ClassSymbol) right);
      }
      if(right.isArrayType()){
        return left == ((ArraySymbol) right).getSuperClass();
      }
      if(right.isNullType()){
        return true;
      }
      return false;
    }
    if(left.isArrayType()){
      if(right.isArrayType()){
        return isSuperTypeForArray((ArraySymbol) left, (ArraySymbol) right);
      }
      if(right.isNullType()){
        return true;
      }
      return false;
    }
    return false;
  }
  
  public static boolean isAssignable(
    TypeSymbol left, TypeSymbol right){
    if(isSuperType(left, right) || isSuperType(right, left)){
      return true;
    }else{
      return false;
    }
  }
  
  private static boolean isSuperTypeForArray(
    ArraySymbol left, ArraySymbol right){
    return isSuperType(left.getBase(), right.getBase());
  }
  
  private static boolean isSuperTypeForClass(ClassSymbol left, ClassSymbol right){
    if(right == null) return false;
    if(left == right) return true;
    if(isSuperTypeForClass(left, right.getSuperClass())) return true;
    for(int i = 0; i < right.getInterfaces().length; i++){
      if(isSuperTypeForClass(left, right.getInterfaces()[i])) return true;
    }
    return false;
  }
  
  private static boolean isSuperTypeForBasic(
    BasicSymbol left, BasicSymbol right){
    if(left == BasicSymbol.DOUBLE){
      if(
        right == BasicSymbol.CHAR		||
        right == BasicSymbol.BYTE		|| right == BasicSymbol.SHORT || 
        right == BasicSymbol.INT		|| right == BasicSymbol.LONG	|| 
        right == BasicSymbol.FLOAT	|| right == BasicSymbol.DOUBLE){
        return true;
      }else{
        return false;
      }
    }
    if(left == BasicSymbol.FLOAT){
      if(
        right == BasicSymbol.CHAR		|| right == BasicSymbol.BYTE	|| 
        right == BasicSymbol.SHORT	|| right == BasicSymbol.INT		|| 
        right == BasicSymbol.LONG		|| right == BasicSymbol.FLOAT){
        return true;
      }else{
        return false;
      }
    }
    if(left == BasicSymbol.LONG){
      if(
        right == BasicSymbol.CHAR		|| right == BasicSymbol.BYTE	||
        right == BasicSymbol.SHORT	|| right == BasicSymbol.INT		|| 
        right == BasicSymbol.LONG){
        return true;
      }else{
        return false;
      }
    }
    if(left == BasicSymbol.INT){
      if(
        right == BasicSymbol.CHAR		|| right == BasicSymbol.BYTE	|| 
        right == BasicSymbol.SHORT	|| right == BasicSymbol.INT){
        return true;
      }else{
        return false;
      }
    }
    if(left == BasicSymbol.SHORT){
      if(right == BasicSymbol.BYTE || right == BasicSymbol.SHORT){
        return true;
      }else{
        return false;
      }
    }
    if(left == BasicSymbol.BOOLEAN && right == BasicSymbol.BOOLEAN) return true;    
    if(left == BasicSymbol.BYTE && right == BasicSymbol.BYTE) return true;
    return false;
  }
}