/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 *  
 */
public class ForStatement extends Statement {
  private final Statement initializer;

  private final Expression condition;

  private final Expression increment;

  private final BlockStatement block;

  public ForStatement(Statement initializer, Expression condition, Expression increment, BlockStatement block) {
    this.initializer = initializer;
    this.condition = condition;
    this.increment = increment;
    this.block = block;
    setChild(initializer);
    setChild(condition);
    setChild(increment);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }

  public Statement getInitializer() {
    return initializer;
  }

  public Expression getCondition() {
    return condition;
  }

  public Expression getIncrement() {
    return increment;
  }

  public BlockStatement getBlock() {
    return block;
  }
  
}