/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;

/**
 * Represents top level method.
 * @author Kota Mizushima
 *
 */
public class FunctionDeclaration extends TopLevelElement {
  
  private int modifier;
  
  private String name;
  
  private ArgumentDeclaration[] arguments;
  
  private TypeSpecifier returnType;
  
  private BlockStatement block;

  public FunctionDeclaration(String name, ArgumentDeclaration[] arguments, TypeSpecifier returnType, BlockStatement block) {
    this.name = name;
    this.block = block;
    this.arguments = arguments;
    this.returnType = returnType;
    setChildren(arguments);
    setChild(block);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
  
  public ArgumentDeclaration[] getArguments(){
    return (ArgumentDeclaration[])arguments.clone();
  }
  
  public TypeSpecifier getReturnType(){
    return returnType;
  }

  public BlockStatement getBlock() {
    return block;
  }
  
  public void setModifier(int modifier){
    this.modifier = modifier;
  }
  
  public int getModifier(){
    return modifier;
  }

  public String getName() {
    return name;
  }

  public void setName(String name){
    this.name = name;
  }
}