/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 *  
 */
public class InterfaceDeclaration extends TypeDeclaration {
  
  private TypeSpecifier[] interfaces;

  private InterfaceMethodDeclaration[] declarations;

  /**
   * @param parent
   */
  public InterfaceDeclaration(String name, TypeSpecifier[] interfaces, InterfaceMethodDeclaration[] declarations) {
    super(name);
    this.declarations = declarations;
    this.interfaces = interfaces;
    setChildren(declarations);
    setChildren(interfaces);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }

  /**
   * @return Returns the method declarations.
   */
  public InterfaceMethodDeclaration[] getDeclarations() {
    return (InterfaceMethodDeclaration[])declarations.clone();
  }

  /**
   * 
   * @return Rerurns the super interfaces.
   */
  public TypeSpecifier[] getInterfaces() {
    return (TypeSpecifier[]) interfaces.clone();
  }
  
}