/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;

import java.util.List;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author mizu
 */
public abstract class SimpleAbstractSyntaxTreeNode implements AbstractSyntaxTreeNode {
  private AbstractSyntaxTreeNode parent;
  private SourcePosition sourcePosition;
  private int column;
  private int row;
  
  public SimpleAbstractSyntaxTreeNode() {
  }

  public int getColumn() {
    return column;
  }

  public void setColumn(int column) {
    this.column = column;
  }

  public int getRow() {
    return row;
  }

  public void setRow(int row) {
    this.row = row;
  }

  public void setParent(AbstractSyntaxTreeNode parent) {
    this.parent = parent;
  }

  public AbstractSyntaxTreeNode getParent() {
    return parent;
  }

  public SourcePosition getSourcePosition() {
    return sourcePosition;
  }
  
  public void setSourcePosition(SourcePosition sourcePosition) {
    this.sourcePosition = sourcePosition;
  }
  
  protected void setChild(AbstractSyntaxTreeNode child){
    if(child != null){ child.setParent(this); }
  }
  
  protected void setChildren(AbstractSyntaxTreeNode[] children){
    for(int i = 0; i < children.length; i++){
      children[i].setParent(this);
    }
  }
  
  protected void setChildren(List children){
    for(int i = 0; i < children.size(); i++){
      ((AbstractSyntaxTreeNode)children.get(i)).setParent(this);
    }
  }
}