/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;



/**
 * @author Kota Mizushima
 *  
 */
public class StaticMethodCall extends Expression {
  private TypeSpecifier target;

  private String methodName;

  private Expression[] arguments;

  public StaticMethodCall(
    TypeSpecifier target, String methodName, Expression[] arguments) {
    this.target =  target;
    this.setMethodName(methodName);
    this.setArguments(arguments);
    setChildren(arguments);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }

  public void setTarget(TypeSpecifier target) {
    this.target = target;
  }

  public TypeSpecifier getTarget() {
    return target;
  }
  
  public void setMethodName(String methodName) {
    this.methodName = methodName;
  }

  public String getMethodName() {
    return methodName;
  }  

  public void setArguments(Expression[] arguments) {
    this.arguments = arguments;
  }

  public Expression[] getArguments() {
    return (Expression[])arguments.clone();
  }


  
}