/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;

import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 * 
 */
public class TypeSpecifier extends SimpleAbstractSyntaxTreeNode {
  
  private TypeComponent component;
  
  private final int dimension;
  
  private final TypeSpecifier[] typeArguments;
  
  public TypeSpecifier(TypeComponent component, int dimension, TypeSpecifier[] typeArguments) {
    this.component = component;
    this.dimension = dimension;
    this.typeArguments = typeArguments;
  }
  
  public int getSizeOfTypeArguments(){
    return typeArguments.length;
  }
  
  public TypeSpecifier getTypeArgument(int index){
    return typeArguments[index];
  }

  public TypeComponent getComponent() {
    return component;
  }
  
  public String getComponentName(){
    return component.getName();
  }
  
  public int getComponentKind(){
    return component.getKind();
  }
  
  public int getDimension() {
    return dimension;
  }
  
  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
  
}