/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment;

import java.util.Iterator;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.onion_lang.onion.compiler.environment.LocalFrame;

public class CodeProxy {
    private InstructionList code = new InstructionList();
    private InstructionFactory factory;
    private LocalFrame frame;
    private int frameObjectIndex;
    private int[] indexTable;
    private MethodGen method;

    public CodeProxy(ConstantPoolGen pool) {
        this.factory = new InstructionFactory(pool);
    }

    public void setFrame(LocalFrame frame) {
        this.frame = frame;
    }

    public LocalFrame getFrame() {
        return this.frame;
    }

    public int getFrameObjectIndex() {
        return this.frameObjectIndex;
    }

    public void setFrameObjectIndex(int frameObjectIndex) {
        this.frameObjectIndex = frameObjectIndex;
    }

    public void setIndexTable(int[] indexTable) {
        this.indexTable = indexTable;
    }

    public int index(int index) {
        return this.indexTable[index];
    }

    public int[] getIndexTable() {
        return this.indexTable;
    }

    public void setMethod(MethodGen method) {
        this.method = method;
    }

    public MethodGen getMethod() {
        return this.method;
    }

    public InstructionList getCode() {
        return this.code;
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, ObjectType catch_type) {
        return this.method.addExceptionHandler(start_pc, end_pc, handler_pc, catch_type);
    }

    public LineNumberGen addLineNumber(InstructionHandle ih, int src_line) {
        return this.method.addLineNumber(ih, src_line);
    }

    public InstructionHandle appendDefaultValue(Type type) {
        InstructionHandle start = type instanceof BasicType ? (type == BasicType.BOOLEAN ? this.appendConstant(new Boolean(false)) : (type == BasicType.BYTE ? this.appendConstant(new Byte(0)) : (type == BasicType.SHORT ? this.appendConstant(new Short(0)) : (type == BasicType.CHAR ? this.appendConstant(new Character('\u0000')) : (type == BasicType.INT ? this.appendConstant(new Integer(0)) : (type == BasicType.LONG ? this.appendConstant(new Long(0L)) : (type == BasicType.FLOAT ? this.appendConstant(new Float(0.0f)) : (type == BasicType.DOUBLE ? this.appendConstant(new Double(0.0)) : this.append(InstructionConstants.NOP))))))))) : this.appendNull(type);
        return start;
    }

    public ObjectType boxingType(Type type) {
        if (type instanceof BasicType) {
            ObjectType makeType = null;
            if (type == BasicType.BOOLEAN) {
                makeType = new ObjectType("java.lang.Boolean");
            } else if (type == BasicType.BYTE) {
                makeType = new ObjectType("java.lang.Byte");
            } else if (type == BasicType.SHORT) {
                makeType = new ObjectType("java.lang.Short");
            } else if (type == BasicType.CHAR) {
                makeType = new ObjectType("java.lang.Character");
            } else if (type == BasicType.INT) {
                makeType = new ObjectType("java.lang.Integer");
            } else if (type == BasicType.LONG) {
                makeType = new ObjectType("java.lang.Long");
            } else if (type == BasicType.FLOAT) {
                makeType = new ObjectType("java.lang.Float");
            } else if (type == BasicType.DOUBLE) {
                makeType = new ObjectType("java.lang.Double");
            } else {
                throw new RuntimeException();
            }
            return makeType;
        }
        return null;
    }

    public InstructionHandle appendArrayLoad(Type type) {
        return this.code.append(InstructionFactory.createArrayLoad(type));
    }

    public InstructionHandle appendArrayStore(Type type) {
        return this.code.append(InstructionFactory.createArrayStore(type));
    }

    public InstructionHandle appendBinaryOperation(String op, Type type) {
        return this.code.append(InstructionFactory.createBinaryOperation(op, type));
    }

    public BranchHandle appendBranchInstruction(short opcode, InstructionHandle target) {
        return this.code.append(InstructionFactory.createBranchInstruction(opcode, target));
    }

    public InstructionHandle appendDup(int size) {
        return this.code.append(InstructionFactory.createDup(size));
    }

    public InstructionHandle appendDup_1(int size) {
        return this.code.append(InstructionFactory.createDup_1(size));
    }

    public InstructionHandle appendDup_2(int size) {
        return this.code.append(InstructionFactory.createDup_2(size));
    }

    public InstructionHandle appendLoad(Type type, int index) {
        return this.code.append(InstructionFactory.createLoad(type, index));
    }

    public InstructionHandle appendNull(Type type) {
        return this.code.append(InstructionFactory.createNull(type));
    }

    public InstructionHandle appendPop(int size) {
        return this.code.append(InstructionFactory.createPop(size));
    }

    public InstructionHandle appendReturn(Type type) {
        return this.code.append(InstructionFactory.createReturn(type));
    }

    public InstructionHandle appendStore(Type type, int index) {
        return this.code.append(InstructionFactory.createStore(type, index));
    }

    public InstructionHandle appendThis() {
        return this.code.append(InstructionFactory.createThis());
    }

    public InstructionHandle appendAppend(Type type) {
        return this.code.append(this.factory.createAppend(type));
    }

    public InstructionHandle appendCast(Type src_type, Type dest_type) {
        return this.code.append(this.factory.createCast(src_type, dest_type));
    }

    public InstructionHandle appendCheckCast(ReferenceType t) {
        return this.code.append(this.factory.createCheckCast(t));
    }

    public InstructionHandle appendConstant(Object value) {
        return this.code.append(this.factory.createConstant(value));
    }

    public InstructionHandle appendFieldAccess(String class_name, String name, Type type, short kind) {
        return this.code.append(this.factory.createFieldAccess(class_name, name, type, kind));
    }

    public InstructionHandle appendGetField(String class_name, String name, Type t) {
        return this.code.append(this.factory.createGetField(class_name, name, t));
    }

    public InstructionHandle appendGetStatic(String class_name, String name, Type t) {
        return this.code.append(this.factory.createGetStatic(class_name, name, t));
    }

    public InstructionHandle appendInstanceOf(ReferenceType t) {
        return this.code.append(this.factory.createInstanceOf(t));
    }

    public InstructionHandle appendInvoke(String class_name, String name, Type ret_type, Type[] arg_types, short kind) {
        return this.code.append(this.factory.createInvoke(class_name, name, ret_type, arg_types, kind));
    }

    public InstructionHandle appendNew(String s) {
        return this.code.append(this.factory.createNew(s));
    }

    public InstructionHandle appendNew(ObjectType t) {
        return this.code.append(this.factory.createNew(t));
    }

    public InstructionHandle appendNewArray(Type t, short dim) {
        return this.code.append(this.factory.createNewArray(t, dim));
    }

    public InstructionHandle appendPutField(String class_name, String name, Type t) {
        return this.code.append(this.factory.createPutField(class_name, name, t));
    }

    public InstructionHandle appendPutStatic(String class_name, String name, Type t) {
        return this.code.append(this.factory.createPutStatic(class_name, name, t));
    }

    public BranchHandle append(BranchInstruction i) {
        return this.code.append(i);
    }

    public InstructionHandle append(CompoundInstruction c) {
        return this.code.append(c);
    }

    public InstructionHandle append(Instruction i) {
        return this.code.append(i);
    }

    public InstructionHandle append(Instruction i, CompoundInstruction c) {
        return this.code.append(i, c);
    }

    public InstructionHandle append(Instruction i, Instruction j) {
        return this.code.append(i, j);
    }

    public InstructionHandle append(Instruction i, InstructionList il) {
        return this.code.append(i, il);
    }

    public BranchHandle append(InstructionHandle ih, BranchInstruction i) {
        return this.code.append(ih, i);
    }

    public InstructionHandle append(InstructionHandle ih, CompoundInstruction c) {
        return this.code.append(ih, c);
    }

    public InstructionHandle append(InstructionHandle ih, Instruction i) {
        return this.code.append(ih, i);
    }

    public InstructionHandle append(InstructionHandle ih, InstructionList il) {
        return this.code.append(ih, il);
    }

    public InstructionHandle append(InstructionList il) {
        return this.code.append(il);
    }

    public InstructionHandle getEnd() {
        return this.code.getEnd();
    }

    public InstructionHandle[] getInstructionHandles() {
        return this.code.getInstructionHandles();
    }

    public int[] getInstructionPositions() {
        return this.code.getInstructionPositions();
    }

    public Instruction[] getInstructions() {
        return this.code.getInstructions();
    }

    public int getLength() {
        return this.code.getLength();
    }

    public InstructionHandle getStart() {
        return this.code.getStart();
    }

    public BranchHandle insert(BranchInstruction i) {
        return this.code.insert(i);
    }

    public InstructionHandle insert(CompoundInstruction c) {
        return this.code.insert(c);
    }

    public InstructionHandle insert(Instruction i) {
        return this.code.insert(i);
    }

    public InstructionHandle insert(Instruction i, CompoundInstruction c) {
        return this.code.insert(i, c);
    }

    public InstructionHandle insert(Instruction i, Instruction j) {
        return this.code.insert(i, j);
    }

    public InstructionHandle insert(Instruction i, InstructionList il) {
        return this.code.insert(i, il);
    }

    public BranchHandle insert(InstructionHandle ih, BranchInstruction i) {
        return this.code.insert(ih, i);
    }

    public InstructionHandle insert(InstructionHandle ih, CompoundInstruction c) {
        return this.code.insert(ih, c);
    }

    public InstructionHandle insert(InstructionHandle ih, Instruction i) {
        return this.code.insert(ih, i);
    }

    public InstructionHandle insert(InstructionHandle ih, InstructionList il) {
        return this.code.insert(ih, il);
    }

    public InstructionHandle insert(InstructionList il) {
        return this.code.insert(il);
    }

    public boolean isEmpty() {
        return this.code.isEmpty();
    }

    public Iterator iterator() {
        return this.code.iterator();
    }

    public void move(InstructionHandle ih, InstructionHandle target) {
        this.code.move(ih, target);
    }

    public void move(InstructionHandle start, InstructionHandle end, InstructionHandle target) {
        this.code.move(start, end, target);
    }

    public void redirectBranches(InstructionHandle old_target, InstructionHandle new_target) {
        this.code.redirectBranches(old_target, new_target);
    }

    public void redirectExceptionHandlers(CodeExceptionGen[] exceptions, InstructionHandle old_target, InstructionHandle new_target) {
        this.code.redirectExceptionHandlers(exceptions, old_target, new_target);
    }

    public void redirectLocalVariables(LocalVariableGen[] lg, InstructionHandle old_target, InstructionHandle new_target) {
        this.code.redirectLocalVariables(lg, old_target, new_target);
    }

    public void update() {
        this.code.update();
    }
}

